/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.request;

import java.util.Map;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

public class InstanceEnumerationMap extends ResourceRead<Map<String, Resource>> {

	public InstanceEnumerationMap(Resource instance) {
		super(instance);
	}

	@Override
	public Map<String, Resource> perform(ReadGraph graph) throws DatabaseException {

		Layer0 L0 = Layer0.getInstance(graph);
		Resource parent = graph.getSingleObject(resource, L0.PartOf);
		return graph.sync(new EnumerationMap(parent));

	}

}
