/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.adaption;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.adaption.Adapter;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.Read;

public abstract class SimpleAdapter<T> implements Adapter<T, Resource> {

    public abstract T adapt(ReadGraph g, Resource r) throws DatabaseException;

    @Override
    public void adapt(AsyncReadGraph g, final Resource source, final Resource r, AsyncProcedure<T> procedure) {

        //System.out.println("SimpleAdapter.adapt" + this.getClass());

        g.asyncRequest(new Read<T>() {

            @Override
            public T perform(ReadGraph graph) throws DatabaseException {
                //System.out.println("SimpleAdapter.perform" + this.getClass());
                return adapt(graph, r);
            }

        }, procedure);

    }

}
