/*******************************************************************************
 * Copyright (c) 2007, 2024 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy  - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common;

import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.QueryDeserializer;
import org.simantics.db.request.QueryFactory;
import org.simantics.db.request.Read;

abstract public class ReadQueryFactory<V> implements QueryFactory {

	abstract public Read<V> readKey(QueryDeserializer deserializer) throws DatabaseException;
	abstract public V readValue(QueryDeserializer deserializer) throws DatabaseException;
	
	@Override
	public void readEntry(QueryDeserializer deserializer) throws DatabaseException {
		Read<V> r = readKey(deserializer);
		V v = readValue(deserializer);
		deserializer.store(r, v);
	}

	@Override
	public void parent(QueryDeserializer deserializer) throws DatabaseException {
		deserializer.parent(readKey(deserializer));
	}
	
}
