/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common;

import org.simantics.db.Resource;

/**
 * 
 */
public class NamedResource implements Comparable<NamedResource> {
    String   name;
    Resource resource;

    public NamedResource(String name, Resource resource) {
    	assert(name != null);
    	assert(resource != null);
        this.name = name;
        this.resource = resource;
    }

    public String getName() {
        return name;
    }

    public Resource getResource() {
        return resource;
    }

    @Override
    public int compareTo(NamedResource o) {
        return name.compareToIgnoreCase(o.name);
    }

    @Override
    public String toString() {
        return name;
    }

    @Override
    public int hashCode() {
        return resource.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        NamedResource other = (NamedResource) obj;
        return resource.equals(other.resource) && name.equals(other.name);
    }

}
