/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.datatypes.literal;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.util.Bean;

public final class Vec2d
extends Bean {
    public static final Binding BINDING = Bindings.getBindingUnchecked(Vec2d.class);
    public double x;
    public double y;

    public Vec2d(double x, double y) {
        super(BINDING);
        this.x = x;
        this.y = y;
    }

    public boolean isZero() {
        return this.x == 0.0 && this.y == 0.0;
    }

    public double norm1() {
        return Math.abs(this.x) + Math.abs(this.y);
    }

    public double norm2() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double length() {
        return this.norm2();
    }

    public double dot(Vec2d other) {
        return this.x * other.x + this.y * other.y;
    }

    public Vec2d sum(Vec2d other) {
        return new Vec2d(this.x + other.x, this.y + other.y);
    }

    public Vec2d subtraction(Vec2d other) {
        return new Vec2d(this.x - other.x, this.y - other.y);
    }

    public String toString() {
        return "Vec2d[x=" + this.x + ", y=" + this.y + "]";
    }
}

