/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.util.binary;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.simantics.databoard.util.binary.BinaryWriteable;
import org.simantics.databoard.util.binary.UTF8;

public class OutputStreamWriteable
implements BinaryWriteable {
    OutputStream out;

    public OutputStreamWriteable(OutputStream out) {
        if (out == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.out = out;
    }

    public OutputStream getStream() {
        return this.out;
    }

    void _put(int value) throws IOException {
        this.out.write(value);
    }

    @Override
    public void write(int b) throws IOException {
        this._put(b);
    }

    @Override
    public void writeByte(int b) throws IOException {
        this._put(b);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this._put(v ? 1 : 0);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void writeFully(ByteBuffer src) throws IOException {
        block1: {
            if (!src.hasArray()) ** GOTO lbl8
            array = src.array();
            this.write(array, src.position(), src.remaining());
            src.position(src.limit());
            break block1;
lbl-1000:
            // 1 sources

            {
                this._put(src.get());
lbl8:
                // 2 sources

                ** while (src.hasRemaining())
            }
        }
    }

    @Override
    public void writeFully(ByteBuffer src, int length) throws IOException {
        if (src.hasArray()) {
            byte[] array = src.array();
            this.write(array, src.position(), length);
            src.position(length);
        } else {
            int i = 0;
            while (i < length) {
                this._put(src.get());
                ++i;
            }
        }
    }

    @Override
    public void write(byte[] src, int offset, int length) throws IOException {
        this.out.write(src, offset, length);
    }

    @Override
    public void write(byte[] src) throws IOException {
        this.out.write(src);
    }

    @Override
    public void writeDouble(double value) throws IOException {
        this.writeLong(Double.doubleToLongBits(value));
    }

    @Override
    public void writeFloat(float value) throws IOException {
        this.writeInt(Float.floatToIntBits(value));
    }

    @Override
    public void writeInt(int value) throws IOException {
        this._put(value >> 24);
        this._put(value >> 16);
        this._put(value >> 8);
        this._put(value);
    }

    @Override
    public void writeLong(long value) throws IOException {
        this._put((int)(value >> 56));
        this._put((int)(value >> 48));
        this._put((int)(value >> 40));
        this._put((int)(value >> 32));
        this._put((int)(value >> 24));
        this._put((int)(value >> 16));
        this._put((int)(value >> 8));
        this._put((int)value);
    }

    @Override
    public void writeShort(int value) throws IOException {
        this._put(value >> 8);
        this._put(value);
    }

    @Override
    public void writeChar(int value) throws IOException {
        this._put(value >> 8);
        this._put(value);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        int len = s.length();
        int i = 0;
        while (i < len) {
            this._put((byte)s.charAt(i));
            ++i;
        }
    }

    @Override
    public void writeChars(String s) throws IOException {
        int len = s.length();
        int i = 0;
        while (i < len) {
            char v = s.charAt(i);
            this._put(v >>> 8 & 0xFF);
            this._put(v >>> 0 & 0xFF);
            ++i;
        }
    }

    @Override
    public void writeUTF(String s) throws IOException {
        int len = UTF8.getModifiedUTF8EncodingByteLength(s);
        this.writeShort(len);
        UTF8.writeModifiedUTF(this, s);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }
}

