/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.util.binary;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class Endian {
    public static void writeUInt24(DataOutput out, int value) throws IOException {
        out.write(value >> 16 & 0xFF);
        out.write(value >> 8 & 0xFF);
        out.write(value & 0xFF);
    }

    public static int readUInt24(DataInput in) throws IOException {
        return in.readByte() << 16 & 0xFFFFFF | in.readByte() << 8 | in.readByte();
    }

    public static void writeDynamicUInt32(DataOutput out, int length) throws IOException {
        if (length < 128) {
            out.write((byte)length);
        } else if ((length -= 128) < 16384) {
            out.write(length & 0x3F | 0x80);
            out.write(length >>> 6);
        } else if ((length -= 16384) < 0x200000) {
            out.write(length & 0x1F | 0xC0);
            out.write(length >>> 5 & 0xFF);
            out.write(length >>> 13 & 0xFF);
        } else if ((length -= 0x200000) < 0x10000000) {
            out.write(length & 0xF | 0xE0);
            out.write(length >>> 4 & 0xFF);
            out.write(length >>> 12 & 0xFF);
            out.write(length >>> 20 & 0xFF);
        } else {
            out.write((length -= 0x10000000) & 7 | 0xF0);
            out.write(length >>> 3 & 0xFF);
            out.write(length >>> 11 & 0xFF);
            out.write(length >>> 19 & 0xFF);
            out.write(length >>> 27 & 0xFF);
        }
    }

    public static void writeDynamicUInt32(byte[] out, int offset, int length) throws IOException {
        if (length < 128) {
            out[offset] = (byte)length;
        } else if ((length -= 128) < 16384) {
            out[offset] = (byte)(length & 0x3F | 0x80);
            out[offset + 1] = (byte)(length >>> 6);
        } else if ((length -= 16384) < 0x200000) {
            out[offset] = (byte)(length & 0x1F | 0xC0);
            out[offset + 1] = (byte)(length >>> 5 & 0xFF);
            out[offset + 2] = (byte)(length >>> 13 & 0xFF);
        } else if ((length -= 0x200000) < 0x10000000) {
            out[offset] = (byte)(length & 0xF | 0xE0);
            out[offset + 1] = (byte)(length >>> 4 & 0xFF);
            out[offset + 2] = (byte)(length >>> 12 & 0xFF);
            out[offset + 3] = (byte)(length >>> 20 & 0xFF);
        } else {
            out[offset] = (byte)((length -= 0x10000000) & 7 | 0xF0);
            out[offset + 1] = (byte)(length >>> 3 & 0xFF);
            out[offset + 2] = (byte)(length >>> 11 & 0xFF);
            out[offset + 3] = (byte)(length >>> 19 & 0xFF);
            out[offset + 4] = (byte)(length >>> 27 & 0xFF);
        }
    }

    public static long readDynamicUInt32(byte[] in, int offset) throws IOException {
        int length = in[offset] & 0xFF;
        int bytes = 1;
        if (length >= 128) {
            if (length >= 192) {
                if (length >= 224) {
                    if (length >= 240) {
                        length &= 0xF;
                        length += (in[offset + 1] & 0xFF) << 3;
                        length += (in[offset + 2] & 0xFF) << 11;
                        length += (in[offset + 3] & 0xFF) << 19;
                        length += (in[offset + 4] & 0xFF) << 27;
                        length += 270549120;
                        bytes = 5;
                    } else {
                        length &= 0x1F;
                        length += (in[offset + 1] & 0xFF) << 4;
                        length += (in[offset + 2] & 0xFF) << 12;
                        length += (in[offset + 3] & 0xFF) << 20;
                        length += 2113664;
                        bytes = 4;
                    }
                } else {
                    length &= 0x3F;
                    length += (in[offset + 1] & 0xFF) << 5;
                    length += (in[offset + 2] & 0xFF) << 13;
                    length += 16512;
                    bytes = 3;
                }
            } else {
                length &= 0x7F;
                length += (in[offset + 1] & 0xFF) << 6;
                length += 128;
                bytes = 2;
            }
        }
        return (long)length | (long)bytes << 32;
    }

    public static int readDynamicUInt32(DataInput in) throws IOException {
        int length = in.readByte() & 0xFF;
        if (length >= 128) {
            if (length >= 192) {
                if (length >= 224) {
                    if (length >= 240) {
                        length &= 0xF;
                        length += (in.readByte() & 0xFF) << 3;
                        length += (in.readByte() & 0xFF) << 11;
                        length += (in.readByte() & 0xFF) << 19;
                        length += (in.readByte() & 0xFF) << 27;
                        length += 270549120;
                    } else {
                        length &= 0x1F;
                        length += (in.readByte() & 0xFF) << 4;
                        length += (in.readByte() & 0xFF) << 12;
                        length += (in.readByte() & 0xFF) << 20;
                        length += 2113664;
                    }
                } else {
                    length &= 0x3F;
                    length += (in.readByte() & 0xFF) << 5;
                    length += (in.readByte() & 0xFF) << 13;
                    length += 16512;
                }
            } else {
                length &= 0x7F;
                length += (in.readByte() & 0xFF) << 6;
                length += 128;
            }
        }
        return length;
    }

    public static int getDynamicUInt32Length(int length) {
        if (length < 128) {
            return 1;
        }
        if (length < 16512) {
            return 2;
        }
        if (length < 0x204000) {
            return 3;
        }
        if (length < 0x10200000) {
            return 4;
        }
        return 5;
    }

    public static int getUInt(DataInput in, int maxValue) throws IOException {
        if (maxValue == 0) {
            return 0;
        }
        if (maxValue < 256) {
            return in.readByte() & 0xFF;
        }
        if (maxValue < 65536) {
            return in.readShort() & 0xFFFF;
        }
        if (maxValue < 0x1000000) {
            return Endian.readUInt24(in) & 0xFFFFFF;
        }
        return in.readInt();
    }

    public static int getUIntLength(int maxValue) {
        if (maxValue == 0) {
            return 0;
        }
        if (maxValue < 256) {
            return 1;
        }
        if (maxValue < 65536) {
            return 2;
        }
        if (maxValue < 0x1000000) {
            return 3;
        }
        return 4;
    }

    public static void putUInt(DataOutput out, int value, int maxValue) throws IOException {
        if (maxValue != 0) {
            if (maxValue < 256) {
                out.write(value);
            } else if (maxValue < 65536) {
                out.writeShort(value);
            } else if (maxValue < 0x1000000) {
                Endian.writeUInt24(out, value);
            } else {
                out.writeInt(value);
            }
        }
    }

    public static long readLong(byte[] in) {
        return ((long)in[0] << 56) + ((long)(in[1] & 0xFF) << 48) + ((long)(in[2] & 0xFF) << 40) + ((long)(in[3] & 0xFF) << 32) + ((long)(in[4] & 0xFF) << 24) + (long)((in[5] & 0xFF) << 16) + (long)((in[6] & 0xFF) << 8) + (long)((in[7] & 0xFF) << 0);
    }

    public static int readInt(byte[] in) {
        return ((in[0] & 0xFF) << 24) + ((in[1] & 0xFF) << 16) + ((in[2] & 0xFF) << 8) + ((in[3] & 0xFF) << 0);
    }

    public static long readLong(byte[] in, int offset) {
        return ((long)in[offset + 0] << 56) + ((long)(in[offset + 1] & 0xFF) << 48) + ((long)(in[offset + 2] & 0xFF) << 40) + ((long)(in[offset + 3] & 0xFF) << 32) + ((long)(in[offset + 4] & 0xFF) << 24) + (long)((in[offset + 5] & 0xFF) << 16) + (long)((in[offset + 6] & 0xFF) << 8) + (long)((in[offset + 7] & 0xFF) << 0);
    }

    public static int readInt(byte[] in, int offset) {
        return ((in[offset + 0] & 0xFF) << 24) + ((in[offset + 1] & 0xFF) << 16) + ((in[offset + 2] & 0xFF) << 8) + ((in[offset + 3] & 0xFF) << 0);
    }
}

