/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.type;

import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.simantics.databoard.accessor.error.ReferenceException;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.IdentityPair;
import org.simantics.databoard.util.Limit;
import org.simantics.databoard.util.Range;
import org.simantics.databoard.util.RangeException;

public class StringType
extends Datatype {
    public static final String KEY_PATTERN = "pattern";
    public static final String KEY_MIMETYPE = "mimeType";
    public static final String KEY_LENGTH = "length";
    private transient Range _length;
    private transient String _lengthIsForStr;
    private transient Pattern pattern_;
    private transient String pattern_IsForStr;

    public StringType() {
    }

    public StringType(String pattern) {
        this.setPattern(pattern);
    }

    public StringType(String pattern, String mimeType, Range length) {
        this.setPattern(pattern);
        this.setMimeType(mimeType);
        this.setLength(length);
    }

    public StringType(String pattern, String mimeType, String length) {
        this.setPattern(pattern);
        this.setMimeType(mimeType);
        this.setLength(length);
    }

    @Override
    public int getComponentCount() {
        return 0;
    }

    @Override
    public Datatype getComponentType(int index) {
        throw new IllegalArgumentException();
    }

    @Override
    public Datatype getComponentType(ChildReference path) {
        if (path == null) {
            return this;
        }
        throw new IllegalArgumentException();
    }

    @Override
    protected boolean deepEquals(Object obj, Set<IdentityPair<Datatype, Datatype>> compareHistory) {
        if (this == obj) {
            return true;
        }
        if (!this.hasEqualMetadata(obj)) {
            return false;
        }
        return obj instanceof StringType;
    }

    @Override
    public int hashCode() {
        return 1130849059 + super.hashCode();
    }

    @Override
    public void accept(Datatype.Visitor1 v, Object obj) {
        v.visit(this, obj);
    }

    @Override
    public <T> T accept(Datatype.Visitor<T> v) {
        return v.visit(this);
    }

    public String getPattern() {
        return (String)this.metadata.get(KEY_PATTERN);
    }

    public void setPattern(String pattern) throws PatternSyntaxException {
        if (pattern == null) {
            this.metadata.remove(KEY_PATTERN);
        } else {
            this.metadata.put(KEY_PATTERN, pattern);
        }
    }

    public String getMimeType() {
        return (String)this.metadata.get(KEY_MIMETYPE);
    }

    public void setMimeType(String mimeType) {
        if (mimeType == null) {
            this.metadata.remove(KEY_MIMETYPE);
        } else {
            this.metadata.put(KEY_MIMETYPE, mimeType);
        }
    }

    public Range getLength() {
        String lengthStr = (String)this.metadata.get(KEY_LENGTH);
        if (lengthStr == null) {
            return null;
        }
        if (lengthStr == this._lengthIsForStr) {
            return this._length;
        }
        try {
            this._lengthIsForStr = lengthStr;
            this._length = Range.valueOf(lengthStr);
        }
        catch (RangeException rangeException) {
            this._length = null;
        }
        return this._length;
    }

    public int minLength() {
        if (this._length == null) {
            return 0;
        }
        Limit l = this._length.getLower();
        int value = l.getValue().intValue();
        if (l.isExclusive()) {
            ++value;
        }
        return value;
    }

    public int maxLength() {
        if (this._length == null) {
            return Integer.MAX_VALUE;
        }
        Limit l = this._length.getUpper();
        int value = l.getValue().intValue();
        if (l.isExclusive()) {
            --value;
        }
        return value;
    }

    public Pattern getCompiledPattern() {
        String patternStr = (String)this.metadata.get(KEY_PATTERN);
        if (patternStr == null) {
            return null;
        }
        if (patternStr == this.pattern_IsForStr) {
            return this.pattern_;
        }
        try {
            this.pattern_IsForStr = patternStr;
            this.pattern_ = Pattern.compile(patternStr);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            this.pattern_ = null;
        }
        return this.pattern_;
    }

    public void setLength(String length) {
        if (length == null) {
            this.metadata.remove(KEY_LENGTH);
        } else {
            this.metadata.put(KEY_LENGTH, length);
        }
    }

    public void setLength(Range range) {
        if (range == null) {
            this._length = null;
            this._lengthIsForStr = null;
            this.metadata.remove(KEY_LENGTH);
        } else {
            this._length = range;
            this._lengthIsForStr = range.toString();
            this.metadata.put(KEY_LENGTH, this._lengthIsForStr);
        }
    }

    @Override
    public <T extends Datatype> T getChildType(ChildReference reference) throws ReferenceException {
        if (reference == null) {
            return (T)this;
        }
        throw new ReferenceException(String.valueOf(reference.getClass()) + " is not a subreference of StringType");
    }
}

