/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding.mutable;

import java.io.IOException;
import org.simantics.databoard.Accessors;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.VariantAccessor;
import org.simantics.databoard.accessor.error.AccessorConstructionException;
import org.simantics.databoard.accessor.java.JavaObject;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.error.RuntimeBindingException;
import org.simantics.databoard.binding.reflection.VoidBinding;
import org.simantics.databoard.parser.DataValuePrinter;
import org.simantics.databoard.parser.PrintFormat;
import org.simantics.databoard.parser.repository.DataValueRepository;
import org.simantics.databoard.parser.unparsing.DataTypePrinter;
import org.simantics.databoard.type.Datatype;

public class Variant
implements Comparable<Variant>,
Cloneable {
    Binding binding;
    Object value;

    public static Variant ofInstance(Object instance) {
        Object binding = Bindings.getBindingUnchecked(instance.getClass());
        return new Variant((Binding)binding, instance);
    }

    public Variant() {
        this.binding = VoidBinding.VOID_BINDING;
        this.value = null;
    }

    public Variant(Variant v) {
        this.binding = v.getBinding();
        this.value = v.getValue();
    }

    public Variant(Binding binding, Object value) {
        this.binding = binding;
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public Object getValue(Binding binding) throws AdaptException {
        return Bindings.adapt(this.value, this.binding, binding);
    }

    public VariantAccessor getAccessor() {
        try {
            return (VariantAccessor)Accessors.getAccessor(Bindings.VARIANT, this);
        }
        catch (AccessorConstructionException e) {
            throw new RuntimeException(e);
        }
    }

    public Datatype type() {
        return this.binding.type();
    }

    public Binding getBinding() {
        return this.binding;
    }

    public int hashCode() {
        try {
            return this.binding.hashValue(this.value);
        }
        catch (BindingException e) {
            throw new RuntimeBindingException(e);
        }
    }

    public boolean equals(Object obj) {
        Variant o;
        block6: {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Variant)) {
                return false;
            }
            try {
                o = (Variant)obj;
                if (o.binding != this.binding || o.value != this.value) break block6;
                return true;
            }
            catch (BindingException e) {
                throw new RuntimeBindingException(e);
            }
        }
        return Bindings.equals(this.binding, this.value, o.binding, o.value);
    }

    public boolean valueEquals(Binding binding, Object obj) {
        if (this.binding == binding) {
            return binding.equals(obj, this.value);
        }
        try {
            Object adapted = Bindings.adapt(obj, binding, this.binding);
            return this.binding.equals(adapted, this.value);
        }
        catch (AdaptException adaptException) {
            return false;
        }
    }

    @Override
    public int compareTo(Variant o) {
        block3: {
            try {
                if (o.binding != this.binding || o.value != this.value) break block3;
                return 0;
            }
            catch (BindingException e) {
                throw new RuntimeBindingException(e);
            }
        }
        return Bindings.compare(this.binding, this.value, o.binding, o.value);
    }

    public String toString() {
        try {
            StringBuilder sb = new StringBuilder();
            DataValueRepository repo = new DataValueRepository();
            DataValuePrinter printer = new DataValuePrinter(sb, repo);
            printer.setFormat(PrintFormat.SINGLE_LINE);
            printer.print(this.binding, this.value);
            sb.append(" : ");
            DataTypePrinter printer2 = new DataTypePrinter(sb);
            printer2.print(this.binding.type());
            return sb.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (BindingException e) {
            throw new RuntimeBindingException(e);
        }
    }

    public Variant clone() {
        if (this.binding.isImmutable()) {
            return new Variant(this.binding, this.value);
        }
        Object newValue = Bindings.cloneUnchecked(this.value, this.binding, this.binding);
        return new Variant(this.binding, newValue);
    }

    boolean isValid(Binding binding, Object obj) throws RuntimeBindingException {
        try {
            binding.assertInstaceIsValid(obj);
            return true;
        }
        catch (BindingException e) {
            throw new RuntimeBindingException(e);
        }
    }

    public Variant getComponent(ChildReference ref) throws AccessorConstructionException {
        if (ref == null) {
            return this;
        }
        JavaObject jo = (JavaObject)Accessors.getAccessor(this, ref);
        return new Variant(jo.getBinding(), jo.getObject());
    }
}

