/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding;

import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.accessor.reference.IndexReference;
import org.simantics.databoard.accessor.reference.LabelReference;
import org.simantics.databoard.accessor.reference.NameReference;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.BooleanBinding;
import org.simantics.databoard.binding.ByteBinding;
import org.simantics.databoard.binding.DoubleBinding;
import org.simantics.databoard.binding.FloatBinding;
import org.simantics.databoard.binding.IntegerBinding;
import org.simantics.databoard.binding.LongBinding;
import org.simantics.databoard.binding.OptionalBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.error.RuntimeBindingException;
import org.simantics.databoard.binding.impl.BindingPrintContext;
import org.simantics.databoard.type.Component;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.util.IdentityHashSet;
import org.simantics.databoard.util.IdentityPair;

public abstract class RecordBinding
extends Binding {
    public Binding[] componentBindings;

    public Binding getComponentBinding(String fieldName) {
        int fieldIndex = this.type().getComponentIndex2(fieldName);
        if (fieldIndex < 0) {
            return null;
        }
        return this.getComponentBinding(fieldIndex);
    }

    public Object getComponentObject(Object obj, String fieldName) throws BindingException {
        int fieldIndex = this.type().getComponentIndex2(fieldName);
        if (fieldIndex < 0) {
            return null;
        }
        return this.getComponent(obj, fieldIndex);
    }

    public int getComponentIndex(String fieldName) {
        return this.type().getComponentIndex2(fieldName);
    }

    @Override
    public Binding getComponentBinding(int fieldIndex) {
        return this.componentBindings[fieldIndex];
    }

    public Binding[] getComponentBindings() {
        return this.componentBindings;
    }

    protected void setComponentBindings(Binding[] componentBindings) {
        this.componentBindings = componentBindings;
    }

    @Override
    public RecordType type() {
        return (RecordType)this.type;
    }

    @Override
    public int getComponentCount() {
        return this.type().getComponentCount();
    }

    public abstract Object getComponent(Object var1, int var2) throws BindingException;

    public abstract Object create(Object ... var1) throws BindingException;

    public abstract Object createPartial() throws BindingException;

    public abstract void setComponents(Object var1, Object ... var2) throws BindingException;

    public abstract void setComponent(Object var1, int var2, Object var3) throws BindingException;

    public void setComponent(Object obj, String fieldName, Object value) throws BindingException {
        int fieldIndex = this.type().getComponentIndex2(fieldName);
        if (fieldIndex < 0) {
            throw new BindingException("Field " + fieldName + " does not exist.");
        }
        this.setComponent(obj, fieldIndex, value);
    }

    @Override
    public void readFrom(Binding srcBinding, Object src, Object dst) throws BindingException {
        RecordBinding sb = (RecordBinding)srcBinding;
        int len = this.getComponentCount();
        if (sb.getComponentCount() != len) {
            throw new BindingException("field count mismatch");
        }
        try {
            int i = 0;
            while (i < len) {
                Binding dcb = this.getComponentBinding(i);
                Binding scb = sb.getComponentBinding(i);
                Object sc = sb.getComponent(src, i);
                if (dcb.isImmutable()) {
                    Object cv = Bindings.clone(sc, scb, dcb);
                    this.setComponent(dst, i, cv);
                } else {
                    Object v = this.getComponent(dst, i);
                    v = dcb.readFromTry(scb, sc, v);
                    this.setComponent(dst, i, v);
                }
                ++i;
            }
        }
        catch (AdaptException e) {
            throw new BindingException(e);
        }
    }

    @Override
    public void accept(Binding.Visitor1 v, Object obj) {
        v.visit(this, obj);
    }

    @Override
    public <T> T accept(Binding.Visitor<T> v) {
        return v.visit(this);
    }

    @Override
    public void assertInstaceIsValid(Object obj, Set<Object> validInstances) throws BindingException {
        if (!this.isInstance(obj)) {
            throw new BindingException("The object (" + String.valueOf(obj) + ") is not correct instance.");
        }
        RecordType type = this.type();
        int length = type.getComponentCount();
        if (type.isReferable()) {
            if (validInstances == null) {
                validInstances = new IdentityHashSet<Object>();
            }
            if (validInstances.contains(obj)) {
                return;
            }
            validInstances.add(obj);
        }
        int i = 0;
        while (i < length) {
            Binding componentBinding = this.getComponentBindings()[i];
            Object componentValue = this.getComponent(obj, i);
            componentBinding.assertInstaceIsValid(componentValue, validInstances);
            ++i;
        }
    }

    @Override
    public int deepHashValue(Object value, IdentityHashMap<Object, Object> hashedObjects) throws BindingException {
        if (this.type().isReferable()) {
            if (hashedObjects == null) {
                hashedObjects = new IdentityHashMap(1);
            }
            if (hashedObjects.containsKey(value)) {
                return 0;
            }
            hashedObjects.put(value, null);
        }
        int result = 3;
        int len = this.componentBindings.length;
        int i = 0;
        while (i < len) {
            Object element = this.getComponent(value, i);
            result += 31 * result + this.componentBindings[i].deepHashValue(element, hashedObjects);
            ++i;
        }
        return result;
    }

    @Override
    public int deepCompare(Object o1, Object o2, Set<IdentityPair<Object, Object>> compareHistory) throws BindingException {
        RecordType rt = this.type();
        if (rt.isReferable()) {
            IdentityPair<Object, Object> p;
            if (compareHistory == null) {
                compareHistory = new HashSet<IdentityPair<Object, Object>>();
            }
            if (compareHistory.contains(p = new IdentityPair<Object, Object>(o1, o2))) {
                return 0;
            }
            compareHistory.add(p);
        }
        int len = rt.getComponentCount();
        int i = 0;
        while (i < len) {
            Object v2;
            Object v1;
            Binding c = this.getComponentBindings()[i];
            int dif = c.deepCompare(v1 = this.getComponent(o1, i), v2 = this.getComponent(o2, i), compareHistory);
            if (dif != 0) {
                return dif;
            }
            ++i;
        }
        return 0;
    }

    public Object createUnchecked(Object ... values) throws RuntimeBindingException {
        try {
            return this.create(values);
        }
        catch (BindingException e) {
            throw new RuntimeBindingException(e);
        }
    }

    public void setComponentsUnchecked(Object obj, Object ... value) throws RuntimeBindingException {
        try {
            this.setComponents(obj, value);
        }
        catch (BindingException e) {
            throw new RuntimeBindingException(e);
        }
    }

    public void setComponentUnchecked(Object obj, int index, Object value) throws RuntimeBindingException {
        try {
            this.setComponent(obj, index, value);
        }
        catch (BindingException e) {
            throw new RuntimeBindingException(e);
        }
    }

    protected void toStringAux(Object value, BindingPrintContext ctx) throws BindingException {
        ctx.b.append('{');
        Component[] components = this.type().getComponents();
        boolean first = true;
        int i = 0;
        while (i < components.length) {
            if (first) {
                first = false;
            } else {
                ctx.b.append(", ");
                if (!ctx.singleLine) {
                    ctx.b.append('\n');
                }
            }
            Binding binding = this.getComponentBinding(i);
            Object cval = this.getComponent(value, i);
            if (!(binding instanceof OptionalBinding) || ((OptionalBinding)binding).hasValue(cval)) {
                Component component = components[i];
                ctx.b.append(component.name);
                ctx.b.append(" = ");
                binding.toString(cval, ctx);
            }
            ++i;
        }
        ctx.b.append('}');
    }

    @Override
    protected void toString(Object value, BindingPrintContext ctx) throws BindingException {
        if (this.type().isReferable()) {
            if (ctx.refs.contains(value)) {
                int val = ctx.refs.get(value);
                if (val < 0) {
                    val = ctx.nameCount.value++;
                    ctx.refs.put(value, val);
                }
                ctx.b.append((char)(97 + val));
            } else {
                ctx.refs.put(value, -1);
                this.toStringAux(value, ctx);
                int val = ctx.refs.remove(value);
                if (val >= 0) {
                    ctx.b.append("/");
                    ctx.b.append((char)(97 + val));
                }
            }
        } else {
            this.toStringAux(value, ctx);
        }
    }

    @Override
    public Binding getComponentBinding(ChildReference path) throws IllegalArgumentException {
        if (path == null) {
            return this;
        }
        if (path instanceof IndexReference) {
            IndexReference ir = (IndexReference)path;
            return this.componentBindings[ir.index].getComponentBinding(path.childReference);
        }
        if (path instanceof NameReference) {
            NameReference nr = (NameReference)path;
            return this.getComponentBinding(nr.name).getComponentBinding(path.childReference);
        }
        if (path instanceof LabelReference) {
            LabelReference lr = (LabelReference)path;
            try {
                Integer i = new Integer(lr.label);
                return this.getComponentBinding(i).getComponentBinding(path.childReference);
            }
            catch (NumberFormatException numberFormatException) {
                return this.getComponentBinding(lr.label).getComponentBinding(path.childReference);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean isImmutable() {
        return this.getComponentCount() == 0;
    }

    public void setBoolean(Object r, int index, boolean z) throws BindingException {
        this.setComponent(r, index, ((BooleanBinding)this.componentBindings[index]).create(z));
    }

    public boolean getBoolean(Object r, int index) throws BindingException {
        return ((BooleanBinding)this.componentBindings[index]).getValue_(this.getComponent(r, index));
    }

    public void setByte(Object r, int index, byte x) throws BindingException {
        this.setComponent(r, index, ((ByteBinding)this.componentBindings[index]).create(x));
    }

    public byte getByte(Object r, int index) throws BindingException {
        return ((ByteBinding)this.componentBindings[index]).getValue_(this.getComponent(r, index));
    }

    public void setInt(Object r, int index, int x) throws BindingException {
        this.setComponent(r, index, ((IntegerBinding)this.componentBindings[index]).create(x));
    }

    public int getInt(Object r, int index) throws BindingException {
        return ((IntegerBinding)this.componentBindings[index]).getValue_(this.getComponent(r, index));
    }

    public void setLong(Object r, int index, long x) throws BindingException {
        this.setComponent(r, index, ((LongBinding)this.componentBindings[index]).create(x));
    }

    public long getLong(Object r, int index) throws BindingException {
        return ((LongBinding)this.componentBindings[index]).getValue_(this.getComponent(r, index));
    }

    public void setFloat(Object r, int index, float x) throws BindingException {
        this.setComponent(r, index, ((FloatBinding)this.componentBindings[index]).create(x));
    }

    public float getFloat(Object r, int index) throws BindingException {
        return ((FloatBinding)this.componentBindings[index]).getValue_(this.getComponent(r, index));
    }

    public void setDouble(Object r, int index, double x) throws BindingException {
        this.setComponent(r, index, ((DoubleBinding)this.componentBindings[index]).create(x));
    }

    public double getDouble(Object r, int index) throws BindingException {
        return ((DoubleBinding)this.componentBindings[index]).getValue_(this.getComponent(r, index));
    }

    @Override
    protected boolean deepEquals(Object obj, Set<IdentityPair<Binding, Binding>> compareHistory) {
        RecordBinding o = (RecordBinding)obj;
        if (!super.deepEquals(obj, compareHistory)) {
            return false;
        }
        if (this.componentBindings.length != o.componentBindings.length) {
            return false;
        }
        int i = 0;
        while (i < this.componentBindings.length) {
            if (!this.componentBindings[i].equals((Object)o.componentBindings[i], compareHistory)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public int deepHashCode(IdentityHashMap<Object, Object> hashedObjects) {
        int code = super.deepHashCode(hashedObjects);
        int i = 0;
        while (i < this.componentBindings.length) {
            code = 17 * code + this.componentBindings[i].hashCode(hashedObjects);
            ++i;
        }
        return code;
    }
}

