/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.accessor.reference;

import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.util.URIUtil;

public class NameReference
extends ChildReference {
    public String name;

    public NameReference(String name) {
        this.name = name;
    }

    public NameReference(String name, ChildReference child) {
        super(child);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String toString(boolean labelReference) {
        if (labelReference && (this.name.equals("uv") || this.name.equals("o") || this.name.equals("v"))) {
            labelReference = false;
        }
        String encoded = URIUtil.encodeURI(this.name);
        return labelReference ? encoded : "n-" + encoded;
    }

    @Override
    public ChildReference clone() {
        return new NameReference(this.name, this.childReference == null ? null : this.childReference.clone());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NameReference)) {
            return false;
        }
        NameReference other = (NameReference)obj;
        if (!other.name.equals(this.name)) {
            return false;
        }
        if (other.hasChildReference() != this.hasChildReference()) {
            return false;
        }
        return !this.hasChildReference() || other.childReference.equals(this.childReference);
    }

    public int hashCode() {
        int hash = 4665456 + 37 * this.name.hashCode();
        if (this.hasChildReference()) {
            hash = 31 * hash + this.childReference.hashCode();
        }
        return hash;
    }
}

