/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard;

import java.io.IOException;
import java.util.Comparator;
import java.util.Map;
import org.simantics.databoard.Databoard;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.adapter.Adapter;
import org.simantics.databoard.adapter.AdapterConstructionException;
import org.simantics.databoard.adapter.AdapterFactory;
import org.simantics.databoard.adapter.RuntimeAdaptException;
import org.simantics.databoard.adapter.RuntimeAdapterConstructionException;
import org.simantics.databoard.annotations.ArgumentImpl;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.BooleanBinding;
import org.simantics.databoard.binding.ByteBinding;
import org.simantics.databoard.binding.DoubleBinding;
import org.simantics.databoard.binding.FloatBinding;
import org.simantics.databoard.binding.IntegerBinding;
import org.simantics.databoard.binding.LongBinding;
import org.simantics.databoard.binding.StringBinding;
import org.simantics.databoard.binding.VariantBinding;
import org.simantics.databoard.binding.classfactory.TypeClassFactory;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.error.RuntimeBindingConstructionException;
import org.simantics.databoard.binding.factory.BindingRepository;
import org.simantics.databoard.binding.factory.TypeBindingFactory;
import org.simantics.databoard.binding.impl.BooleanArrayBinding;
import org.simantics.databoard.binding.impl.BooleanBindingDefault;
import org.simantics.databoard.binding.impl.ByteArrayBinding;
import org.simantics.databoard.binding.impl.ByteBindingDefault;
import org.simantics.databoard.binding.impl.DoubleArrayBinding;
import org.simantics.databoard.binding.impl.DoubleBindingDefault;
import org.simantics.databoard.binding.impl.FloatArrayBinding;
import org.simantics.databoard.binding.impl.FloatBindingDefault;
import org.simantics.databoard.binding.impl.IntArrayBinding;
import org.simantics.databoard.binding.impl.IntegerBindingDefault;
import org.simantics.databoard.binding.impl.LongArrayBinding;
import org.simantics.databoard.binding.impl.LongBindingDefault;
import org.simantics.databoard.binding.impl.StringArrayBinding;
import org.simantics.databoard.binding.impl.StringBindingDefault;
import org.simantics.databoard.binding.impl.UnsignedByteBinding;
import org.simantics.databoard.binding.impl.UnsignedIntegerBinding;
import org.simantics.databoard.binding.impl.UnsignedLongBinding;
import org.simantics.databoard.binding.mutable.MutableBooleanBinding;
import org.simantics.databoard.binding.mutable.MutableByteBinding;
import org.simantics.databoard.binding.mutable.MutableDoubleBinding;
import org.simantics.databoard.binding.mutable.MutableFloatBinding;
import org.simantics.databoard.binding.mutable.MutableIntegerBinding;
import org.simantics.databoard.binding.mutable.MutableLongBinding;
import org.simantics.databoard.binding.mutable.MutableStringBinding;
import org.simantics.databoard.binding.mutable.MutableVariantBinding;
import org.simantics.databoard.binding.reflection.BindingProvider;
import org.simantics.databoard.binding.reflection.BindingRequest;
import org.simantics.databoard.binding.reflection.ClassBindingFactory;
import org.simantics.databoard.binding.reflection.VoidBinding;
import org.simantics.databoard.serialization.RuntimeSerializerConstructionException;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.serialization.SerializerConstructionException;
import org.simantics.databoard.serialization.SerializerScheme;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.DataValueUtil;

public class Bindings {
    public static final Databoard databoard;
    public static final Map<Datatype, Binding> mutableBindingRepository;
    public static final Map<Datatype, Binding> defaultBindingRepository;
    public static final BindingRepository bindingRepository;
    public static final Map<Binding, Serializer> serializerRepository;
    public static final TypeBindingFactory mutableBindingFactory;
    public static final TypeBindingFactory defaultBindingFactory;
    public static final ClassBindingFactory classBindingFactory;
    public static final SerializerScheme serializationFactory;
    public static final AdapterFactory adapterFactory;
    public static final TypeClassFactory typeClassFactory;
    public static final StringBinding STRING;
    public static final IntegerBinding INTEGER;
    public static final BooleanBinding BOOLEAN;
    public static final ByteBinding BYTE;
    public static final LongBinding LONG;
    public static final DoubleBinding DOUBLE;
    public static final FloatBinding FLOAT;
    public static final VariantBinding VARIANT;
    public static final VariantBinding OBJECT;
    public static final VariantBinding STR_VARIANT;
    public static final Binding VOID;
    public static final Binding BEAN;
    public static final Binding DATATYPE;
    public static final ArrayBinding BOOLEAN_ARRAY;
    public static final ArrayBinding BYTE_ARRAY;
    public static final ArrayBinding INT_ARRAY;
    public static final ArrayBinding LONG_ARRAY;
    public static final ArrayBinding FLOAT_ARRAY;
    public static final ArrayBinding DOUBLE_ARRAY;
    public static final ArrayBinding STRING_ARRAY;
    public static final StringBinding MUTABLE_STRING;
    public static final IntegerBinding MUTABLE_INTEGER;
    public static final BooleanBinding MUTABLE_BOOLEAN;
    public static final ByteBinding MUTABLE_BYTE;
    public static final LongBinding MUTABLE_LONG;
    public static final FloatBinding MUTABLE_FLOAT;
    public static final DoubleBinding MUTABLE_DOUBLE;
    public static final VariantBinding MUTABLE_VARIANT;
    public static final IntegerBinding UNSIGNED_INTEGER;
    public static final ByteBinding UNSIGNED_BYTE;
    public static final LongBinding UNSIGNED_LONG;
    public static final IntegerBinding MUTABLE_UNSIGNED_INTEGER;
    public static final ByteBinding MUTABLE_UNSIGNED_BYTE;
    public static final LongBinding MUTABLE_UNSIGNED_LONG;

    static {
        STRING = new StringBindingDefault(Datatypes.STRING);
        INTEGER = new IntegerBindingDefault(Datatypes.INTEGER);
        BOOLEAN = new BooleanBindingDefault(Datatypes.BOOLEAN);
        BYTE = new ByteBindingDefault(Datatypes.BYTE);
        LONG = new LongBindingDefault(Datatypes.LONG);
        DOUBLE = new DoubleBindingDefault(Datatypes.DOUBLE);
        FLOAT = new FloatBindingDefault(Datatypes.FLOAT);
        VOID = VoidBinding.VOID_BINDING;
        BOOLEAN_ARRAY = new BooleanArrayBinding(Datatypes.BOOLEAN_ARRAY, BOOLEAN);
        BYTE_ARRAY = new ByteArrayBinding(Datatypes.BYTE_ARRAY, BYTE);
        INT_ARRAY = new IntArrayBinding(Datatypes.INTEGER_ARRAY, INTEGER);
        LONG_ARRAY = new LongArrayBinding(Datatypes.LONG_ARRAY, LONG);
        FLOAT_ARRAY = new FloatArrayBinding(Datatypes.FLOAT_ARRAY, FLOAT);
        DOUBLE_ARRAY = new DoubleArrayBinding(Datatypes.DOUBLE_ARRAY, DOUBLE);
        STRING_ARRAY = new StringArrayBinding(Datatypes.STRING_ARRAY, STRING);
        UNSIGNED_INTEGER = new UnsignedIntegerBinding.Immutable(Datatypes.INTEGER);
        UNSIGNED_BYTE = new UnsignedByteBinding.Immutable(Datatypes.BYTE);
        UNSIGNED_LONG = new UnsignedLongBinding.Immutable(Datatypes.LONG);
        MUTABLE_STRING = new MutableStringBinding(Datatypes.STRING);
        MUTABLE_INTEGER = new MutableIntegerBinding(Datatypes.INTEGER);
        MUTABLE_BOOLEAN = new MutableBooleanBinding(Datatypes.BOOLEAN);
        MUTABLE_BYTE = new MutableByteBinding(Datatypes.BYTE);
        MUTABLE_LONG = new MutableLongBinding(Datatypes.LONG);
        MUTABLE_FLOAT = new MutableFloatBinding(Datatypes.FLOAT);
        MUTABLE_DOUBLE = new MutableDoubleBinding(Datatypes.DOUBLE);
        MUTABLE_UNSIGNED_INTEGER = new UnsignedIntegerBinding.Mutable(Datatypes.INTEGER);
        MUTABLE_UNSIGNED_BYTE = new UnsignedByteBinding.Mutable(Datatypes.BYTE);
        MUTABLE_UNSIGNED_LONG = new UnsignedLongBinding.Mutable(Datatypes.LONG);
        databoard = new Databoard();
        mutableBindingRepository = Bindings.databoard.mutableBindingRepository;
        defaultBindingRepository = Bindings.databoard.defaultBindingRepository;
        bindingRepository = Bindings.databoard.bindingRepository;
        serializerRepository = Bindings.databoard.serializerRepository;
        mutableBindingFactory = Bindings.databoard.mutableBindingFactory;
        defaultBindingFactory = Bindings.databoard.defaultBindingFactory;
        classBindingFactory = Bindings.databoard.classBindingFactory;
        serializationFactory = Bindings.databoard.serializationFactory;
        adapterFactory = Bindings.databoard.adapterFactory;
        typeClassFactory = Bindings.databoard.typeClassFactory;
        BEAN = Bindings.databoard.BEAN;
        VARIANT = Bindings.databoard.VARIANT;
        MUTABLE_VARIANT = new MutableVariantBinding(classBindingFactory, adapterFactory);
        STR_VARIANT = Bindings.databoard.STR_VARIANT;
        OBJECT = Bindings.databoard.OBJECT;
        databoard.initialize();
        DATATYPE = Bindings.getBindingUnchecked(Datatype.class);
        bindingRepository.registerClassMapping(Datatype.class, DATATYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Binding> T getMutableBinding(Datatype type) {
        try {
            Binding binding = mutableBindingRepository.get(type);
            if (binding != null) {
                return (T)binding;
            }
            Map<Datatype, Binding> map = mutableBindingRepository;
            synchronized (map) {
                binding = mutableBindingRepository.get(type);
                if (binding != null) {
                    return (T)binding;
                }
                return (T)mutableBindingFactory.getBinding(type);
            }
        }
        catch (BindingConstructionException e) {
            throw new RuntimeBindingConstructionException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Binding> T getBinding(Datatype type) {
        try {
            Binding binding = defaultBindingRepository.get(type);
            if (binding != null) {
                return (T)binding;
            }
            Map<Datatype, Binding> map = defaultBindingRepository;
            synchronized (map) {
                binding = defaultBindingRepository.get(type);
                if (binding != null) {
                    return (T)binding;
                }
                return (T)defaultBindingFactory.getBinding(type);
            }
        }
        catch (BindingConstructionException e) {
            throw new RuntimeBindingConstructionException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Binding> T getBinding(Class<?> clazz) throws BindingConstructionException {
        Binding binding = bindingRepository.get(clazz);
        if (binding != null) {
            return (T)binding;
        }
        BindingRequest request = new BindingRequest(clazz);
        ClassBindingFactory classBindingFactory = Bindings.classBindingFactory;
        synchronized (classBindingFactory) {
            binding = Bindings.classBindingFactory.construct(request);
        }
        return (T)binding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Binding> T getBinding(BindingRequest request) throws BindingConstructionException {
        ClassBindingFactory classBindingFactory = Bindings.classBindingFactory;
        synchronized (classBindingFactory) {
            return (T)Bindings.classBindingFactory.construct(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Binding> T getBinding(Class<?> clazz, Class<?> ... parameters) throws BindingConstructionException {
        BindingRequest request = new BindingRequest(clazz, parameters);
        ClassBindingFactory classBindingFactory = Bindings.classBindingFactory;
        synchronized (classBindingFactory) {
            return (T)Bindings.classBindingFactory.construct(request);
        }
    }

    public static <T extends Binding> T getInstanceBinding(Object obj) throws BindingConstructionException {
        return Bindings.getBinding(obj.getClass());
    }

    public static <T extends Binding> T getBindingUnchecked(Class<?> clazz) throws RuntimeBindingConstructionException {
        try {
            return Bindings.getBinding(clazz);
        }
        catch (BindingConstructionException e) {
            throw new RuntimeBindingConstructionException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Binding> T getBindingUnchecked(Class<?> clazz, Class<?> ... parameters) throws RuntimeBindingConstructionException {
        try {
            ArgumentImpl args = new ArgumentImpl(parameters);
            BindingRequest request = new BindingRequest(clazz, args);
            Binding binding = bindingRepository.get(request);
            if (binding != null) {
                // empty if block
            }
            ClassBindingFactory classBindingFactory = Bindings.classBindingFactory;
            synchronized (classBindingFactory) {
                binding = Bindings.classBindingFactory.construct(request);
            }
            return (T)binding;
        }
        catch (BindingConstructionException e) {
            throw new RuntimeBindingConstructionException(e);
        }
    }

    public static void addBinding(Binding binding, Class<?> clazz, Class<?> ... parameters) {
        ArgumentImpl args = new ArgumentImpl(parameters);
        BindingRequest request = new BindingRequest(clazz, args);
        bindingRepository.put(request, binding);
    }

    public static void addBindingFactory(BindingProvider factory) {
        classBindingFactory.addFactory(factory);
    }

    public static BindingRequest getBeanBindingRequest(Datatype type) throws RuntimeBindingConstructionException {
        try {
            return typeClassFactory.getClass(type);
        }
        catch (BindingConstructionException e) {
            throw new RuntimeBindingConstructionException(e);
        }
    }

    public static Class<?> getBeanClass(Datatype type) throws BindingConstructionException {
        BindingRequest br = typeClassFactory.getClass(type);
        return br.getClazz();
    }

    public static Binding getBeanBinding(Datatype type) throws RuntimeBindingConstructionException {
        try {
            BindingRequest br = typeClassFactory.getClass(type);
            return Bindings.getBinding(br);
        }
        catch (BindingConstructionException e) {
            throw new RuntimeBindingConstructionException(e);
        }
    }

    public static Binding getArrayBinding(Binding componentBinding) {
        return Bindings.getBinding(new ArrayType(componentBinding.type()));
    }

    public static Serializer getSerializer(Binding binding) throws SerializerConstructionException {
        return serializationFactory.getSerializer(binding);
    }

    public static Serializer getSerializerUnchecked(Binding binding) throws RuntimeSerializerConstructionException {
        return serializationFactory.getSerializerUnchecked(binding);
    }

    public static Serializer getSerializer(Class<?> clazz) throws SerializerConstructionException {
        try {
            Object binding = Bindings.getBinding(clazz);
            return serializationFactory.getSerializer((Binding)binding);
        }
        catch (BindingConstructionException e) {
            throw new SerializerConstructionException(e);
        }
    }

    public static Serializer getSerializerUnchecked(Class<?> clazz) throws RuntimeSerializerConstructionException {
        try {
            Object binding = Bindings.getBinding(clazz);
            return serializationFactory.getSerializerUnchecked((Binding)binding);
        }
        catch (BindingConstructionException e) {
            throw new RuntimeSerializerConstructionException(new SerializerConstructionException(e));
        }
    }

    public static Adapter getAdapter(Binding domain, Binding range) throws AdapterConstructionException {
        return adapterFactory.getAdapter(domain, range, false, false);
    }

    public static Adapter getAdapterUnchecked(Binding domain, Binding range) throws RuntimeAdapterConstructionException {
        try {
            return adapterFactory.getAdapter(domain, range, false, false);
        }
        catch (AdapterConstructionException e) {
            throw new RuntimeAdapterConstructionException(e);
        }
    }

    public static Adapter getTypeAdapter(Binding domain, Binding range) throws AdapterConstructionException {
        return adapterFactory.getAdapter(domain, range, true, false);
    }

    public static Adapter getTypeAdapterUnchecked(Binding domain, Binding range) {
        try {
            return adapterFactory.getAdapter(domain, range, true, false);
        }
        catch (AdapterConstructionException e) {
            throw new RuntimeAdapterConstructionException(e);
        }
    }

    public static Object adapt(Object value, Binding domain, Binding range) throws AdaptException {
        try {
            if (domain.equals(range)) {
                return value;
            }
            if (range instanceof VariantBinding) {
                if (domain instanceof VariantBinding) {
                    Binding contentBinding = ((VariantBinding)domain).getContentBinding(value);
                    Object content = ((VariantBinding)domain).getContent(value);
                    return ((VariantBinding)range).create(contentBinding, content);
                }
                return ((VariantBinding)range).create(domain, value);
            }
            if (domain instanceof VariantBinding) {
                return Bindings.adapt(((VariantBinding)domain).getContent(value), ((VariantBinding)domain).getContentBinding(value), range);
            }
            return adapterFactory.getAdapter(domain, range, true, false).adapt(value);
        }
        catch (AdapterConstructionException | BindingException e) {
            throw new AdaptException(e);
        }
    }

    public static Object adaptUnchecked(Object value, Binding domain, Binding range) throws RuntimeAdapterConstructionException, RuntimeAdaptException {
        try {
            if (domain == range) {
                return value;
            }
            if (range instanceof VariantBinding && !(domain instanceof VariantBinding)) {
                return ((VariantBinding)range).create(domain, value);
            }
            return adapterFactory.getAdapter(domain, range, true, false).adaptUnchecked(value);
        }
        catch (RuntimeAdapterConstructionException e) {
            throw new RuntimeAdaptException(new AdaptException(e.getCause()));
        }
        catch (AdapterConstructionException e) {
            throw new RuntimeAdaptException(new AdaptException(e));
        }
        catch (BindingException e) {
            throw new RuntimeAdaptException(new AdaptException(e));
        }
    }

    public static Object clone(Object value, Binding domain, Binding range) throws AdaptException {
        try {
            if (domain == range) {
                if (domain.isImmutable()) {
                    return value;
                }
                return domain.clone(value);
            }
            return adapterFactory.getAdapter(domain, range, true, true).adapt(value);
        }
        catch (AdapterConstructionException e) {
            throw new AdaptException(e);
        }
    }

    public static Object cloneUnchecked(Object value, Binding domain, Binding range) throws RuntimeAdapterConstructionException, RuntimeAdaptException {
        try {
            return adapterFactory.getAdapter(domain, range, true, true).adapt(value);
        }
        catch (AdaptException e) {
            throw new RuntimeAdaptException(e);
        }
        catch (RuntimeAdapterConstructionException e) {
            throw new RuntimeAdaptException(new AdaptException(e.getCause()));
        }
        catch (AdapterConstructionException e) {
            throw new RuntimeAdaptException(new AdaptException(e));
        }
    }

    public static int compare(Binding b1, Object o1, Binding b2, Object o2) throws BindingException {
        return DataValueUtil.compare(b1, o1, b2, o2);
    }

    public static boolean equals(Binding b1, Object o1, Binding b2, Object o2) throws BindingException {
        return DataValueUtil.equals(b1, o1, b2, o2);
    }

    public static Comparator<Object> createComparator(Binding b1, Binding b2) {
        return DataValueUtil.createComparator(b1, b2);
    }

    public static String toString(Object o) {
        try {
            Object b = Bindings.getBinding(o.getClass());
            return ((Binding)b).printValueDefinition(o, true);
        }
        catch (BindingConstructionException e) {
            return "<error " + e.getClass().getName() + " " + e.getMessage() + ">";
        }
        catch (IOException e) {
            return "<error " + e.getClass().getName() + " " + e.getMessage() + ">";
        }
        catch (BindingException e) {
            return "<error " + e.getClass().getName() + " " + e.getMessage() + ">";
        }
    }
}

