/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.type;

import java.util.Set;

import org.simantics.databoard.accessor.error.ReferenceException;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.accessor.reference.ComponentReference;
import org.simantics.databoard.accessor.reference.IndexReference;
import org.simantics.databoard.accessor.reference.KeyReference;
import org.simantics.databoard.accessor.reference.LabelReference;
import org.simantics.databoard.accessor.reference.NameReference;
import org.simantics.databoard.util.IdentityPair;

public class OptionalType extends Datatype {
    public Datatype componentType;
    
    public OptionalType() {    	
    }
    
    public OptionalType(Datatype componentType) {
    	this.componentType = componentType;
    }
    
    public Datatype getComponentType() {
    	return componentType;
    }
    
    @Override
    public int getComponentCount() {
    	return 1;
    }
    
    @Override
    public Datatype getComponentType(int index) {
    	if (index!=0) throw new IllegalArgumentException();
    	return componentType;
    }
    
    @Override
    public Datatype getComponentType(ChildReference path) {
    	if (path==null) return this;
    	if (path instanceof KeyReference) throw new IllegalArgumentException("KeyReference is not supported in OptionalType"); 
    	if (path instanceof NameReference) throw new IllegalArgumentException("NameReference is not supported in OptionalType"); 
    	if (path instanceof IndexReference && ((IndexReference) path).index!=0) throw new IllegalArgumentException("Index out of bounds");
    	if (path instanceof LabelReference && !((LabelReference) path).label.equals("v")) throw new IllegalArgumentException("Unknown label");
    	return componentType.getComponentType(path.childReference);
    }    
    
	@Override
	protected void collectSubtypes(Set<Datatype> subtypes,
		Set<Datatype> recursiveSubtypes) {
		componentType.collectSubtypes(subtypes, recursiveSubtypes);
	}
    
    @Override
    public int hashCode() {
    	return componentType.hashCode() + metadataHashCode();
    }
    
    @Override
    protected boolean deepEquals(Object obj, Set<IdentityPair<Datatype, Datatype>> compareHistory) {
		if (this==obj) return true;
		if (obj instanceof OptionalType == false) return false;
		if ( !hasEqualMetadata(obj) ) return false;
		OptionalType other = (OptionalType) obj;
		return componentType.deepEquals(other.componentType, compareHistory);
    }     

	@Override
	public void accept(Visitor1 v, Object obj) {
	    v.visit(this, obj);        
	}

	@Override
	public <T> T accept(Visitor<T> v) {
	    return v.visit(this);
	}	

	@SuppressWarnings("unchecked")
	@Override
	public <T extends Datatype> T getChildType(ChildReference reference) throws ReferenceException {
		if (reference==null) return (T) this;

		if (reference instanceof LabelReference) {
			LabelReference lr = (LabelReference) reference;
			if (lr.label.equals("o")) {
				return componentType.getChildType(reference.getChildReference());
			}			
		}
		
		if (reference instanceof ComponentReference) {
			return componentType.getChildType(reference.getChildReference());
		} 
		
		throw new ReferenceException(reference.getClass()+" is not a reference of OptionalType");		
	}
	
}
