/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.type;

import java.util.Set;

import org.simantics.databoard.accessor.error.ReferenceException;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.util.IdentityPair;


public class BooleanType extends Datatype {
	
	public BooleanType() {}
		
    @Override
    public int getComponentCount() {
    	return 0;
    }
    
    @Override
    public Datatype getComponentType(int index) {
    	throw new IllegalArgumentException();
    }
    
    @Override
    public Datatype getComponentType(ChildReference path) {
    	if (path==null) return this;
    	throw new IllegalArgumentException();
    }
    
	@Override
	public void accept(Visitor1 v, Object obj) {
	    v.visit(this, obj);        
	}

	@Override
	public <T> T accept(Visitor<T> v) {
	    return v.visit(this);
	}

	@Override
	protected boolean deepEquals(Object obj,
			Set<IdentityPair<Datatype, Datatype>> compareHistory) {
		if (this==obj) return true;
		if ( !hasEqualMetadata(obj) ) return false;
		return obj instanceof BooleanType;
	}
		
	@Override
	public int hashCode() {
		return metadataHashCode() ^ 0xaaee333;
	}    

	@Override
	public boolean equals(Object obj) {
		if ( this==obj ) return true;
		if ( !hasEqualMetadata(obj) ) return false;
		return obj instanceof BooleanType;
	}

	@SuppressWarnings("unchecked")
	@Override
	public <T extends Datatype> T getChildType(ChildReference reference) throws ReferenceException {
		if (reference==null) return (T) this;
		throw new ReferenceException(reference.getClass()+" is not a subreference of BooleanType");	
	}
	
}
