/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.primitives;

public class MutableString implements java.io.Serializable, Comparable<String>, CharSequence {

	private static final long serialVersionUID = 1L;
	
	public String value;
	
	public MutableString() {}
	
	public MutableString(String value) { this.value = value; }

	public String getValue() {
		return value;
	}
	
	public void setValue(String newValue) {
		this.value = newValue;
	}
	
	@Override
	public int compareTo(String o) {
		return value.compareTo(o);
	}
	
	@Override
	public int hashCode() {
		return value.hashCode();
	}
	
	@Override
	public boolean equals(Object obj) {
		if (obj == null) return false;
		if (obj == this) return true;
		
		return value.equals(obj);
	}
	
	@Override
	public String toString() {
		return value;
	}

	@Override
	public char charAt(int index) {
		return value.charAt(index);
	}

	@Override
	public int length() {
		return value.length();
	}

	@Override
	public CharSequence subSequence(int start, int end) {
		return value.subSequence(start, end);
	}
	
}

