/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.primitives;

public class MutableDouble extends Number implements Comparable<MutableDouble> {

	private static final long serialVersionUID = 1L;
	
	public double value;
	
	public MutableDouble() {}
	
	public MutableDouble(double value) { this.value = value; }
	
	public boolean isNaN() {
		return Double.isNaN(value);
	}

	public boolean isInfinite() {
		return Double.isInfinite(value);
	}

	public String toString() {
		return String.valueOf(value);
	}

	public byte byteValue() {
		return (byte) value;
	}

	public short shortValue() {
		return (short) value;
	}

	public int intValue() {
		return (int) value;
	}

	public long longValue() {
		return (long) value;
	}

	public float floatValue() {
		return (float) value;
	}

	public double doubleValue() {
		return (double) value;
	}

	public int hashCode() {
		long bits = Double.doubleToLongBits(value);
		return (int) (bits ^ (bits >>> 32));
	}

	public boolean equals(Object obj) {
		return (obj instanceof MutableDouble)
				&& (Double.doubleToLongBits(((MutableDouble) obj).value) == Double
						.doubleToLongBits(value));
	}

	public int compareTo(MutableDouble anotherDouble) {
		return Double.compare(value, anotherDouble.value);
	}

}

