/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.parser.ast.type;

import org.simantics.databoard.parser.ast.type.visitor.AstTypeVisitor;
import org.simantics.databoard.parser.ast.type.visitor.AstTypeVisitorVoid;

public class AstArrayType extends AstType {
	public final AstType componentType;
	public final Integer minLength;
	public final Integer maxLength;
	
	public AstArrayType(AstType componentType, Integer minLength, Integer maxLength) {	
		this.componentType = componentType;
		this.minLength = minLength;
		this.maxLength = maxLength;
	}

	@Override
	public void accept(AstTypeVisitorVoid v) {
		v.visit(this);
	}

	@Override
	public <T> T accept(AstTypeVisitor<T> v) {
		return v.visit(this);
	}		
}
