/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.binding.reflection;

import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.type.Datatype;

public class ConstantBinding extends RecordBinding {

    Object value;
    
    public ConstantBinding(Datatype type, Object constantValue) {
        this.type = type;
        this.componentBindings = new Binding[0];
        this.value = constantValue;
    }

    @Override
    public Object create(Object... value) throws BindingException {
        return this.value;
    }

    @Override
    public Object getComponent(Object obj, int index) throws BindingException {
        throw new BindingException();
    }

    @Override
    public Object createPartial() throws BindingException {
        return value;
    }

    @Override
    public void setComponents(Object obj, Object... value) throws BindingException {
//        throw new BindingException();
    }
    
    @Override
    public void setComponent(Object obj, int index, Object value)
   		throws BindingException {
//        throw new BindingException();
    }

    @Override
    public boolean isInstance(Object obj) {
        return obj==value;
    }
    
	@Override
	public boolean isImmutable() {
		return true;
	}
	
	@Override
	protected boolean baseEquals( Object obj ) {
	    return super.baseEquals( obj ) && value == ((ConstantBinding)obj).value;
	}
	
	@Override
	public int baseHashCode() {
	    return super.baseHashCode() + 7 * value.hashCode(); 
	}    
}

