/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.binding.factory;

import java.util.HashMap;
import java.util.Map;

import org.simantics.databoard.binding.reflection.BindingRequest;
import org.simantics.databoard.type.Datatype;

public class TypeRepository {

	Map<Datatype, BindingRequest> typeMap = new HashMap<Datatype, BindingRequest>();
	Map<String, BindingRequest> classMap = new HashMap<String, BindingRequest>();
	
	public synchronized void put(Datatype type, BindingRequest br) {
		typeMap.put(type, br);
		classMap.put(br.className.replace('$', '.'), br);
	}
	
	public synchronized boolean containsType( Datatype type ) {
		return typeMap.containsKey( type );
	}
	
	public synchronized BindingRequest getRequestForType(Datatype type) {
		return typeMap.get(type);
	}
	
	public synchronized BindingRequest getRequest(String className) {
		if (className.indexOf('$')>=0) className = className.replace('$', '.');
		return classMap.get(className);
	}
	
}
