/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.accessor.event;

import org.simantics.databoard.accessor.reference.ChildReference;

/**
 * Accessor has been disposed. This is the last event from the accessor. 
 *
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
public class InvalidatedEvent extends Event {

	public InvalidatedEvent() {
	}
	
	@Override
	public InvalidatedEvent clone(ChildReference newReference) {
		InvalidatedEvent result = new InvalidatedEvent();
		result.reference = newReference;
		return result;
	}			
	
	@Override
	public String toString() {
		return toRef()+" Accessor invalidated";
	}
	
}

