/*******************************************************************************
 * Copyright (c) 2010- Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *    VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.accessor;

import org.simantics.databoard.accessor.error.AccessorException;

/**
 * Some accessor implementations may need close. Those implement this interface.
 *
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
public interface CloseableAccessor {

	/**
	 * Close the backend object. If the object is already closed there is no error. 
	 * 
	 * @throws AccessorException
	 */
	void close() throws AccessorException;
	
}

