/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.simantics.Simantics;
import org.simantics.charts.Activator;
import org.simantics.charts.commandlog.NewChartGroupCommand;
import org.simantics.charts.ontology.ChartResource;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.request.WriteResult;
import org.simantics.layer0.Layer0;
import org.simantics.utils.commandlog.Command;
import org.simantics.utils.commandlog.Commands;

public class NewChartGroup
implements ActionFactory {
    public Runnable create(Object target) {
        if (!(target instanceof Resource)) {
            return null;
        }
        Resource parent = (Resource)target;
        return () -> {
            try {
                NewChartGroup.createChartGroup(parent);
            }
            catch (DatabaseException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.charts", "Failed to create chart group.", (Throwable)e));
            }
        };
    }

    public static Resource createChartGroup(Resource target) throws DatabaseException {
        return NewChartGroup.createChartGroup(target, "Chart Group");
    }

    public static Resource createChartGroup(final Resource target, final String chartGroupNameProposal) throws DatabaseException {
        return (Resource)Simantics.getSession().syncRequest((WriteResult)new WriteResultRequest<Resource>(){

            public Resource perform(WriteGraph graph) throws DatabaseException {
                graph.markUndoPoint();
                return NewChartGroup.createChartGroup(graph, target, chartGroupNameProposal);
            }
        });
    }

    public static Resource createChartGroup(WriteGraph g, Resource target, String chartGroupNameProposal) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        ChartResource CHART = ChartResource.getInstance((ReadGraph)g);
        String freshName = NameUtils.findFreshName((ReadGraph)g, (String)chartGroupNameProposal, (Resource)target);
        Resource chart = g.newResource();
        g.claim(chart, L0.InstanceOf, null, CHART.ChartGroup);
        g.claimLiteral(chart, L0.HasName, (Object)freshName, (Binding)Bindings.STRING);
        g.claim(chart, L0.PartOf, target);
        if (Commands.isRecording()) {
            Commands.record((Object)g, (Command)new NewChartGroupCommand(chart, target));
        }
        return chart;
    }
}

