/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.ui;

import java.util.Arrays;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.simantics.charts.editor.HideItemsAction;
import org.simantics.charts.ontology.ChartResource;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.ui.contribution.DynamicMenuContribution;
import org.simantics.ui.utils.ResourceAdaptionUtils;

public class HideItemsContribution
extends DynamicMenuContribution {
    public HideItemsContribution() {
    }

    public HideItemsContribution(String id) {
        super(id);
    }

    protected Object[] getSelectedObjects() {
        return ResourceAdaptionUtils.toResources((Object)this.getSelection());
    }

    protected boolean preAcceptSelection(Object[] selection) {
        return selection.length > 0;
    }

    protected IContributionItem[] getContributionItems(ReadGraph graph, Object[] input) throws DatabaseException {
        HideItemsAction show;
        Resource[] resources = (Resource[])input;
        ChartResource CHART = ChartResource.getInstance((ReadGraph)graph);
        int hidden = 0;
        int visible = 0;
        Resource[] resourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            Resource r = resourceArray[n2];
            if (!graph.isInstanceOf(r, CHART.Chart_Item)) {
                return NONE;
            }
            Boolean isHidden = (Boolean)graph.getPossibleRelatedValue(r, CHART.Chart_Item_hidden, (Binding)Bindings.BOOLEAN);
            if (Boolean.TRUE.equals(isHidden)) {
                ++hidden;
            } else {
                ++visible;
            }
            ++n2;
        }
        HideItemsAction hide = visible > 0 ? new HideItemsAction("Hide Items", true, Arrays.asList(resources)) : null;
        HideItemsAction hideItemsAction = show = hidden > 0 ? new HideItemsAction("Unhide Items", false, Arrays.asList(resources)) : null;
        if (hidden > 0 && visible > 0) {
            return HideItemsContribution.toContributionItems((IAction[])new IAction[]{hide, show});
        }
        if (hidden > 0) {
            return HideItemsContribution.toContributionItems((IAction[])new IAction[]{show});
        }
        return HideItemsContribution.toContributionItems((IAction[])new IAction[]{hide});
    }
}

