/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.query;

import java.util.List;
import org.simantics.Simantics;
import org.simantics.charts.ontology.ChartResource;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Write;

public class HideChartItems
extends WriteRequest {
    private final Boolean hide;
    private final List<Resource> items;

    public HideChartItems(boolean hide, List<Resource> items) {
        this.hide = hide;
        this.items = items;
    }

    public void perform(WriteGraph graph) throws DatabaseException {
        HideChartItems.hideChartItems(graph, this.hide, this.items);
    }

    public static void hideChartItems(WriteGraph graph, boolean hide, List<Resource> items) throws DatabaseException {
        ChartResource CHART = ChartResource.getInstance((ReadGraph)graph);
        for (Resource item : items) {
            if (!graph.isInstanceOf(item, CHART.Chart_Item)) continue;
            graph.claimLiteral(item, CHART.Chart_Item_hidden, (Object)hide, (Binding)Bindings.BOOLEAN);
        }
    }

    public static void hideChartItems(boolean hide, List<Resource> items) throws DatabaseException {
        Session s = Simantics.getSession();
        s.markUndoPoint();
        s.syncRequest((Write)new HideChartItems(hide, items));
    }
}

