/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.ui;

import java.awt.Color;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.browsing.ui.model.images.ImageRule;
import org.simantics.charts.ontology.ChartResource;
import org.simantics.charts.ui.ChartItemIcon;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.trend.impl.JarisPaints;
import org.simantics.utils.datastructures.ArrayMap;

public enum ChartItemImageRule implements ImageRule
{
    INSTANCE;

    public static final String COLUMN_KEY = "single";
    public static final String[] COLUMN_KEYS;
    ChartItemIcon chartIcons = new ChartItemIcon();

    static {
        COLUMN_KEYS = new String[]{COLUMN_KEY};
    }

    public static ChartItemImageRule get() {
        return INSTANCE;
    }

    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class);
    }

    public Map<String, ImageDescriptor> getImage(ReadGraph graph, Object content) throws DatabaseException {
        Resource rend;
        boolean binary;
        Resource item = (Resource)content;
        ChartResource CHART = ChartResource.getInstance((ReadGraph)graph);
        G2DResource G2D = G2DResource.getInstance((ReadGraph)graph);
        Color color = null;
        float[] customColor = (float[])graph.getPossibleRelatedValue(item, G2D.HasColor, (Binding)Bindings.FLOAT_ARRAY);
        if (customColor != null && customColor.length >= 3) {
            color = new Color(customColor[0], customColor[1], customColor[2]);
        }
        if (color == null) {
            Integer index = (Integer)graph.getPossibleRelatedValue(item, CHART.Chart_Item_Index);
            if (index == null) {
                index = 1;
            }
            color = JarisPaints.getColor((int)index);
        }
        ImageDescriptor icon = this.chartIcons.createIcon(!(binary = CHART.Renderer_Binary.equals(rend = graph.getPossibleObject(item, CHART.Chart_Item_Renderer))), color, false);
        return ArrayMap.make((Object[])COLUMN_KEYS, (Object[])new ImageDescriptor[]{icon});
    }
}

