/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.query;

import java.util.UUID;
import org.simantics.charts.ontology.ChartResource;
import org.simantics.charts.ui.ChartItemLabelRule;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Databoard;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.PossibleTypedParent;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleActiveExperiment;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.subscription.SubscriptionItemLabel;
import org.simantics.trend.configuration.Scale;
import org.simantics.trend.configuration.TrendItem;

public class TrendItemQuery
extends ResourceRead<TrendItem> {
    public TrendItemQuery(Resource resource) {
        super(resource);
    }

    public TrendItem perform(ReadGraph graph) throws DatabaseException {
        Resource dm;
        ChartResource CHART = ChartResource.getInstance((ReadGraph)graph);
        G2DResource G2D = G2DResource.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        TrendItem item = new TrendItem();
        item.label = ChartItemLabelRule.INSTANCE.getLabel_(graph, this.resource);
        Double low = null;
        Double high = null;
        Resource sc = graph.getPossibleObject(this.resource, CHART.Chart_Item_ScaleMode);
        if (CHART.ScaleMode_AutoScale.equals(sc)) {
            item.scale = new Scale.Auto();
        } else if (CHART.ScaleMode_ManualScale.equals(sc)) {
            Scale.Manual manualScale = new Scale.Manual();
            item.scale = manualScale;
            low = (Double)graph.getPossibleRelatedValue(this.resource, CHART.Chart_Item_ScaleMode_Min, (Binding)Bindings.DOUBLE);
            high = (Double)graph.getPossibleRelatedValue(this.resource, CHART.Chart_Item_ScaleMode_Max, (Binding)Bindings.DOUBLE);
            manualScale.min = low == null ? 0.0 : low;
            manualScale.max = high == null ? 120.0 : high;
        } else {
            item.scale = new Scale.Auto();
        }
        Integer index = (Integer)graph.getPossibleRelatedValue(this.resource, CHART.Chart_Item_Index);
        item.index = index != null ? index : 1;
        item.renderer = TrendItem.Renderer.Analog;
        Resource rend = graph.getPossibleObject(this.resource, CHART.Chart_Item_Renderer);
        if (CHART.Renderer_Binary.equals(rend)) {
            item.renderer = TrendItem.Renderer.Binary;
        }
        if (CHART.DrawMode_DeviationAndAverage.equals(dm = graph.getPossibleObject(this.resource, CHART.Chart_Item_DrawMode))) {
            item.drawMode = TrendItem.DrawMode.DeviationAndAverage;
        } else if (CHART.DrawMode_Average.equals(dm)) {
            item.drawMode = TrendItem.DrawMode.Average;
        } else if (CHART.DrawMode_Sample.equals(dm)) {
            item.drawMode = TrendItem.DrawMode.Sample;
        } else if (CHART.DrawMode_DeviationAndSample.equals(dm)) {
            item.drawMode = TrendItem.DrawMode.DeviationAndSample;
        } else if (CHART.DrawMode_DeviationAndLine.equals(dm)) {
            item.drawMode = TrendItem.DrawMode.DeviationAndLine;
        } else if (CHART.DrawMode_Line.equals(dm)) {
            item.drawMode = TrendItem.DrawMode.Line;
        } else if (CHART.DrawMode_Deviation.equals(dm)) {
            item.drawMode = TrendItem.DrawMode.Deviation;
        }
        Boolean hidden = (Boolean)graph.getPossibleRelatedValue(this.resource, CHART.Chart_Item_hidden, (Binding)Bindings.BOOLEAN);
        item.hidden = hidden != null ? hidden : false;
        item.customStrokeWidth = (Float)DiagramGraphUtil.getPossibleRelatedValue((ReadGraph)graph, (Resource)this.resource, (Resource)G2D.HasStrokeWidth, Float.class, null);
        float[] color = (float[])graph.getPossibleRelatedValue(this.resource, G2D.HasColor, (Binding)Bindings.FLOAT_ARRAY);
        if (color != null && color.length >= 3) {
            item.customColor = color;
        }
        item.variableId = "";
        item.groupItemId = "";
        Resource subscriptionItem = graph.getPossibleObject(this.resource, CHART.Chart_Item_HasSubscriptionItem);
        Resource subscription = null;
        if (subscriptionItem != null) {
            item.simpleLabel = (String)graph.getPossibleRelatedValue(subscriptionItem, L0.HasLabel, (Binding)Bindings.STRING);
            subscription = (Resource)graph.syncRequest((Read)new PossibleTypedParent(subscriptionItem, MOD.Subscription));
        }
        if (item.simpleLabel == null) {
            item.simpleLabel = "";
        }
        if (subscriptionItem != null) {
            item.groupItemId = (String)graph.getPossibleRelatedValue(subscriptionItem, L0.HasName, (Binding)Bindings.STRING);
            if (item.groupItemId != null) {
                Binding rviBinding = ((Databoard)graph.getService(Databoard.class)).getBindingUnchecked(RVI.class);
                RVI rvi = (RVI)graph.getPossibleRelatedValue(subscriptionItem, MOD.Subscription_Item_VariableId, rviBinding);
                Variable configuration = Variables.getPossibleConfigurationContext((ReadGraph)graph, (Resource)subscription);
                if (configuration != null) {
                    String variableId;
                    Resource activeExperiment = (Resource)graph.syncRequest((Read)new PossibleActiveExperiment(subscription));
                    if (activeExperiment != null) {
                        Variable experimentVariable = null;
                        try {
                            experimentVariable = Variables.switchRealization((ReadGraph)graph, (Variable)configuration, (Resource)activeExperiment);
                        }
                        catch (DatabaseException databaseException) {
                            experimentVariable = Variables.switchPossibleContext((ReadGraph)graph, (Variable)configuration, (Resource)activeExperiment);
                        }
                        if (experimentVariable != null) {
                            configuration = experimentVariable;
                        }
                    }
                    if ((variableId = (String)graph.getPossibleRelatedValue(subscriptionItem, MOD.Subscription_Item_ItemId, (Binding)Bindings.STRING)) == null && rvi != null) {
                        variableId = rvi.toPossibleString(graph, configuration);
                    }
                    item.variableId = item.variableReference = variableId;
                    if (item.variableId != null) {
                        if (item.simpleLabel.isEmpty()) {
                            item.simpleLabel = SubscriptionItemLabel.removeVariablePrefixPath((String)item.variableId);
                        }
                        item.groupId = subscription != null ? (String)graph.getPossibleRelatedValue(subscription, L0.HasName, (Binding)Bindings.STRING) : UUID.randomUUID().toString();
                        if (item.label == null || item.label.isEmpty()) {
                            item.label = item.simpleLabel;
                            if (!item.label.isEmpty() && item.label.charAt(0) == '/') {
                                item.label = item.label.substring(1);
                            }
                        }
                        item.unit = (String)graph.getPossibleRelatedValue(subscriptionItem, MOD.Subscription_Item_Unit, (Binding)Bindings.STRING);
                    }
                }
            }
        }
        if (item.groupItemId == null) {
            item.groupItemId = "";
        }
        if (item.variableId == null) {
            item.variableId = "";
        }
        if (item.groupId == null) {
            item.groupId = "";
        }
        if (item.unit == null) {
            item.unit = "";
        }
        return item;
    }
}

