/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.query;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.ReadInterface;
import org.simantics.event.ontology.EventResource;
import org.simantics.event.view.handler.MilestoneList;
import org.simantics.event.view.handler.MilestoneListQuery;
import org.simantics.layer0.Layer0;
import org.simantics.trend.impl.Milestone;
import org.simantics.trend.impl.MilestoneSpec;

public class MilestoneSpecQuery
extends ResourceRead<MilestoneSpec> {
    public MilestoneSpecQuery(Resource eventlog) {
        super(eventlog);
    }

    public MilestoneSpec perform(ReadGraph graph) throws DatabaseException {
        MilestoneSpec result = new MilestoneSpec();
        result.init();
        result.baseline = -1;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        EventResource EVENT = EventResource.getInstance((ReadGraph)graph);
        Resource experiment = this.resource;
        Resource eventLog = graph.getPossibleObject(experiment, EVENT.IsEventProducerOf);
        if (eventLog != null) {
            MilestoneList ml = (MilestoneList)graph.sync((ReadInterface)new MilestoneListQuery(eventLog));
            for (Resource event : ml.milestones) {
                boolean isMilestone = graph.hasStatement(event, EVENT.Milestone);
                boolean isHidden = graph.hasStatement(event, EVENT.Hidden);
                boolean isBaseline = event.equals(ml.baseline);
                if (!isMilestone && !isBaseline) continue;
                Double creationTime = (Double)graph.getPossibleRelatedValue(event, EVENT.HasTimestamp);
                String milestoneLabel = (String)graph.getPossibleRelatedValue(event, EVENT.Event_milestoneLabel);
                String label = (String)graph.getPossibleRelatedValue(event, L0.HasLabel);
                Milestone ms = new Milestone();
                ms.label = milestoneLabel == null ? "" : milestoneLabel;
                ms.description = label == null ? "" : label;
                ms.id = (String)graph.getRelatedValue(event, L0.HasName);
                ms.time = creationTime == null ? 0.0 : creationTime;
                ms.hidden = isHidden;
                if (isBaseline) {
                    result.baseline = result.milestones.size();
                }
                result.milestones.add(ms);
            }
        }
        return result;
    }

    public Resource getEventLog() {
        return this.resource;
    }
}

