/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.query;

import java.util.Arrays;
import org.simantics.charts.ontology.ChartResource;
import org.simantics.charts.ui.ChartData;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.trend.configuration.YAxisMode;

public class ChartDataWrite
extends WriteRequest {
    ChartData data;
    Resource chart;

    public ChartDataWrite(Resource chart, ChartData data) {
        this.data = data;
        this.chart = chart;
    }

    public void perform(WriteGraph g) throws DatabaseException {
        float[] oldValue;
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        ChartResource CHART = ChartResource.getInstance((ReadGraph)g);
        g.claimLiteral(this.chart, L0.HasName, (Object)this.data.name, (Binding)Bindings.STRING);
        if (this.data.axisMode == YAxisMode.SingleAxis) {
            g.deny(this.chart, CHART.Chart_YAxisMode, CHART.YAxisMode_MultiAxis);
            g.claim(this.chart, CHART.Chart_YAxisMode, CHART.YAxisMode_SingleAxis);
        } else {
            g.deny(this.chart, CHART.Chart_YAxisMode, CHART.YAxisMode_SingleAxis);
            g.claim(this.chart, CHART.Chart_YAxisMode, CHART.YAxisMode_MultiAxis);
        }
        g.claimLiteral(this.chart, CHART.Chart_ShowMilestones, (Object)this.data.showMilestones, (Binding)Bindings.BOOLEAN);
        g.claimLiteral(this.chart, CHART.Chart_showGrid, (Object)this.data.showGrid, (Binding)Bindings.BOOLEAN);
        g.claimLiteral(this.chart, CHART.Chart_trackExperimentTime, (Object)this.data.trackExperimentTime, (Binding)Bindings.BOOLEAN);
        if (this.data.timeIncrement != null) {
            g.claimLiteral(this.chart, CHART.Chart_TimeWindowIncrement, (Object)this.data.timeIncrement, (Binding)Bindings.DOUBLE);
        } else {
            g.deny(this.chart, CHART.Chart_TimeWindowIncrement);
        }
        if (this.data.timeLength == null) {
            g.deny(this.chart, CHART.Chart_TimeWindowLength);
        } else {
            g.claimLiteral(this.chart, CHART.Chart_TimeWindowLength, (Object)this.data.timeLength, (Binding)Bindings.DOUBLE);
        }
        if (this.data.timeStart == null) {
            g.deny(this.chart, CHART.Chart_TimeWindowStart);
        } else {
            g.claimLiteral(this.chart, CHART.Chart_TimeWindowStart, (Object)this.data.timeStart, (Binding)Bindings.DOUBLE);
        }
        if (this.data.allItems != null && this.data.hiddenItems != null) {
            for (ChartData.ItemKey item : this.data.allItems.keySet()) {
                Boolean isHidden;
                boolean shouldBeHidden = this.data.hiddenItems.contains(item);
                if (shouldBeHidden == (isHidden = (Boolean)g.getRelatedValue(item.resource.getResource(), CHART.Chart_Item_hidden, (Binding)Bindings.BOOLEAN))) continue;
                g.claimLiteral(item.resource.getResource(), CHART.Chart_Item_hidden, (Object)shouldBeHidden, (Binding)Bindings.BOOLEAN);
            }
        }
        if (this.data.backgroundColor1 == null) {
            g.denyValue(this.chart, CHART.Chart_backgroundColor);
        } else {
            float[] newValue;
            oldValue = (float[])g.getPossibleRelatedValue(this.chart, CHART.Chart_backgroundColor, (Binding)Bindings.FLOAT_ARRAY);
            float[] fArray = newValue = this.data.backgroundGradient ? ChartDataWrite.joinArrays(this.data.backgroundColor1, this.data.backgroundColor2) : this.data.backgroundColor1;
            if (!(newValue == null || oldValue != null && Arrays.equals(oldValue, newValue))) {
                g.claimLiteral(this.chart, CHART.Chart_backgroundColor, (Object)newValue, (Binding)Bindings.FLOAT_ARRAY);
            }
        }
        if (this.data.gridColor == null) {
            g.denyValue(this.chart, CHART.Chart_gridColor);
        } else {
            oldValue = (float[])g.getPossibleRelatedValue(this.chart, CHART.Chart_gridColor, (Binding)Bindings.FLOAT_ARRAY);
            if (!(this.data.gridColor == null || oldValue != null && Arrays.equals(oldValue, this.data.gridColor))) {
                g.claimLiteral(this.chart, CHART.Chart_gridColor, (Object)this.data.gridColor, (Binding)Bindings.FLOAT_ARRAY);
            }
        }
    }

    private static float[] joinArrays(float[] c1, float[] c2) {
        int l1 = c1 != null ? c1.length : 0;
        int l2 = c2 != null ? c2.length : 0;
        int l = l1 + l2;
        float[] result = new float[l];
        int i = 0;
        if (c1 != null) {
            System.arraycopy(c1, 0, result, 0, l1);
            i += l1;
        }
        if (c2 != null) {
            System.arraycopy(c2, 0, result, i, l2);
            i += l1;
        }
        return result;
    }
}

