/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.preference;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.simantics.charts.Activator;
import org.simantics.charts.preference.Messages;
import org.simantics.trend.configuration.ItemPlacement;
import org.simantics.trend.configuration.LineQuality;
import org.simantics.trend.configuration.TimeFormat;

public class ChartPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private IntegerFieldEditor fRedrawIntervalEditor = null;
    private IntegerFieldEditor fAutoscaleIntervalEditor = null;
    private BooleanFieldEditor fDrawSamplesEditor = null;
    private RadioGroupFieldEditor fTimeFormatEditor = null;
    private RadioGroupFieldEditor fItemPlacementEditor = null;
    private RadioGroupFieldEditor fValueFormatEditor = null;
    private IntegerFieldEditor fDecimalDigitsEditor = null;
    private RadioGroupFieldEditor fLineQualityEditor = null;
    private RadioGroupFieldEditor fTextQualityEditor = null;

    public ChartPreferencePage() {
        super(1);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
    }

    public void createFieldEditors() {
        this.fRedrawIntervalEditor = new IntegerFieldEditor("chart.redraw_interval", Messages.ChartPreferencePage_redrawIntervalLabel, this.getFieldEditorParent());
        this.fRedrawIntervalEditor.setValidRange(1, Integer.MAX_VALUE);
        this.fRedrawIntervalEditor.setErrorMessage(Messages.ChartPreferencePage_redrawIntervalInvalid);
        this.addField((FieldEditor)this.fRedrawIntervalEditor);
        this.fAutoscaleIntervalEditor = new IntegerFieldEditor("chart.autoscale_interval", Messages.ChartPreferencePage_autoscaleIntervalLabel, this.getFieldEditorParent());
        this.fAutoscaleIntervalEditor.setValidRange(1, Integer.MAX_VALUE);
        this.fAutoscaleIntervalEditor.setErrorMessage(Messages.ChartPreferencePage_autoscaleIntervalInvalid);
        this.addField((FieldEditor)this.fAutoscaleIntervalEditor);
        this.fDrawSamplesEditor = new BooleanFieldEditor("chart.draw_samples", Messages.ChartPreferencePage_drawSamplesLabel, this.getFieldEditorParent());
        this.addField((FieldEditor)this.fDrawSamplesEditor);
        this.fTimeFormatEditor = new RadioGroupFieldEditor("chart.timeformat", "Preferred time format", 1, (String[][])new String[][]{{"Time", TimeFormat.Time.name()}, {"Decimal", TimeFormat.Decimal.name()}}, this.getFieldEditorParent());
        this.addField((FieldEditor)this.fTimeFormatEditor);
        this.fValueFormatEditor = new RadioGroupFieldEditor("chart.valueformat", "Preferred value format", 1, (String[][])new String[][]{{"Default", "Default"}, {"Decimal", "Currency"}, {"Scientific", "Scientific"}, {"Engineering", "Engineering"}}, this.getFieldEditorParent());
        this.addField((FieldEditor)this.fValueFormatEditor);
        this.fDecimalDigitsEditor = new IntegerFieldEditor("chart.valueformat.decimal.digits", "Max number of decimal digits in decimal values", this.getFieldEditorParent());
        this.fDecimalDigitsEditor.setValidRange(0, 15);
        this.fDecimalDigitsEditor.setErrorMessage("Number of decimal digits must be between [0,15]");
        this.addField((FieldEditor)this.fDecimalDigitsEditor);
        this.fItemPlacementEditor = new RadioGroupFieldEditor("chart.item_placement", "Item autoscale placement", 1, (String[][])new String[][]{{"Stacked", ItemPlacement.Stacked.name()}, {"Overlapping", ItemPlacement.Overlapping.name()}}, this.getFieldEditorParent());
        this.addField((FieldEditor)this.fItemPlacementEditor);
        this.fLineQualityEditor = new RadioGroupFieldEditor("chart.linequality", "Line Quality", 1, (String[][])new String[][]{{"Normal", LineQuality.Normal.name()}, {"Anti-alias", LineQuality.Antialias.name()}}, this.getFieldEditorParent());
        this.addField((FieldEditor)this.fLineQualityEditor);
        this.fTextQualityEditor = new RadioGroupFieldEditor("chart.textquality", "Text Quality", 1, (String[][])new String[][]{{"Normal", LineQuality.Normal.name()}, {"Anti-alias", LineQuality.Antialias.name()}}, this.getFieldEditorParent());
        this.addField((FieldEditor)this.fTextQualityEditor);
    }

    public void init(IWorkbench workbench) {
    }
}

