/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.export;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.Preferences;
import org.simantics.Simantics;
import org.simantics.charts.query.MilestoneSpecQuery;
import org.simantics.charts.query.TrendSpecQuery;
import org.simantics.databoard.Accessors;
import org.simantics.databoard.accessor.Accessor;
import org.simantics.databoard.accessor.RecordAccessor;
import org.simantics.databoard.accessor.error.AccessorConstructionException;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.type.UnionType;
import org.simantics.databoard.util.Bean;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.request.Read;
import org.simantics.export.core.ExportContext;
import org.simantics.export.core.error.ExportException;
import org.simantics.export.core.manager.Content;
import org.simantics.export.core.pdf.ExportPdfWriter;
import org.simantics.export.core.util.ExportQueries;
import org.simantics.export.core.util.ExporterUtils;
import org.simantics.g2d.canvas.impl.CanvasContext;
import org.simantics.history.History;
import org.simantics.history.HistoryException;
import org.simantics.history.HistoryManager;
import org.simantics.simulation.experiment.IExperiment;
import org.simantics.simulation.experiment.IHistoryExperiment;
import org.simantics.simulation.export.ExperimentExportClass;
import org.simantics.simulation.project.ExperimentManager;
import org.simantics.simulation.project.IExperimentManager;
import org.simantics.trend.TrendInitializer;
import org.simantics.trend.configuration.ItemPlacement;
import org.simantics.trend.configuration.TimeFormat;
import org.simantics.trend.configuration.TrendSpec;
import org.simantics.trend.impl.MilestoneSpec;
import org.simantics.trend.impl.TrendNode;
import org.simantics.utils.datastructures.MapList;
import org.simantics.utils.format.ValueFormat;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;
import org.simantics.utils.threads.WorkerThread;

public class ExportChartPDF
extends ExperimentExportClass {
    public static final RecordType chartOptions;
    public static String S_CHART;
    public static ChildReference P_ITEMPLACEMENT;
    public static ChildReference P_TIMEFORMAT;
    public static ChildReference P_VALUEFORMAT;

    static {
        S_CHART = "Chart";
        P_ITEMPLACEMENT = ChildReference.parsePath((String)(S_CHART + "/Item Placement"));
        P_TIMEFORMAT = ChildReference.parsePath((String)(S_CHART + "/Time Format"));
        P_VALUEFORMAT = ChildReference.parsePath((String)(S_CHART + "/Value Format"));
        chartOptions = new RecordType();
        chartOptions.addComponent("Item Placement", (Datatype)UnionType.newEnum((String[])new String[]{"Stacked", "Overlapping"}));
        chartOptions.addComponent("Time Format", (Datatype)UnionType.newEnum((String[])new String[]{"Decimal", "Time"}));
        chartOptions.addComponent("Value Format", (Datatype)UnionType.newEnum((String[])new String[]{"Currency", "Scientific", "Engineering", "Default"}));
    }

    public void export(List<Content> contents, Object handle, ExportContext ctx, Variant options, IProgressMonitor monitor, MapList<Content, Content> attachmentMap) throws ExportException {
        IExperimentManager em = (IExperimentManager)Simantics.getProject().getHint(ExperimentManager.KEY_EXPERIMENT_MANAGER);
        if (em != null) {
            IExperiment[] iExperimentArray = em.getExperiments();
            int n = iExperimentArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExperiment exp = iExperimentArray[n2];
                if (exp instanceof IHistoryExperiment) {
                    IHistoryExperiment he = (IHistoryExperiment)exp;
                    try {
                        he.flushHistory();
                    }
                    catch (HistoryException historyException) {}
                }
                ++n2;
            }
        }
        final ExportPdfWriter writer = (ExportPdfWriter)handle;
        final WorkerThread workerThread = new WorkerThread("Chart PDF Painter");
        workerThread.start();
        try {
            try {
                final RecordAccessor ra = (RecordAccessor)Accessors.getAccessor((Variant)options);
                List modelRefs = ExperimentExportClass.getResult((ExportContext)ctx, (Variant)options, (boolean)true);
                ArrayList<ChartSettings> charts = new ArrayList<ChartSettings>();
                for (Content content : contents) {
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    Resource chartRes = (Resource)ctx.session.syncRequest(ExportQueries.toResource((String)content.url));
                    Resource model = (Resource)ctx.session.syncRequest((Read)new PossibleModel(chartRes));
                    for (ExperimentExportClass.ModelRef modelRef : modelRefs) {
                        if (!modelRef.resource.equals(model)) continue;
                        for (ExperimentExportClass.ExperimentRef experimentRef : modelRef.experiments) {
                            for (ExperimentExportClass.RunRef runRef : experimentRef.runs) {
                                if (runRef.historyFolder == null || !runRef.historyFolder.exists()) continue;
                                HistoryManager history = History.openFileHistory((File)runRef.historyFolder);
                                ChartSettings cs = new ChartSettings();
                                cs.history = history;
                                cs.modelRef = modelRef;
                                cs.experimentRef = experimentRef;
                                cs.runRef = runRef;
                                cs.chartRes = chartRes;
                                charts.add(cs);
                            }
                        }
                    }
                }
                for (final ChartSettings cs : charts) {
                    UUID id = UUID.randomUUID();
                    final TrendSpec trendSpec = (TrendSpec)ctx.session.syncRequest((Read)new TrendSpecQuery(id, cs.chartRes));
                    if (cs.modelRef.enabledRunCount() > 1) {
                        trendSpec.name = String.valueOf(trendSpec.name) + " / " + cs.runRef.label;
                    }
                    final MilestoneSpec milestones = (MilestoneSpec)ctx.session.syncRequest((Read)new MilestoneSpecQuery(cs.experimentRef.resource));
                    final ExportException[] error = new ExportException[1];
                    ThreadUtils.syncExec((IThreadWorkQueue)workerThread, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            block20: {
                                CanvasContext cctx = TrendInitializer.createDefaultCanvas((IThreadWorkQueue)workerThread, (HistoryManager)cs.history, null, null, (TrendSpec)trendSpec);
                                ExportPdfWriter.Page pdfPage = null;
                                try {
                                    try {
                                        TrendNode trend = TrendInitializer.getTrendNode((CanvasContext)cctx);
                                        trend.printing = true;
                                        String s = ExporterUtils.getUnionValue((Accessor)ra, (ChildReference)P_ITEMPLACEMENT);
                                        if (s != null) {
                                            trend.itemPlacement = ItemPlacement.valueOf((String)s);
                                        }
                                        if ((s = ExporterUtils.getUnionValue((Accessor)ra, (ChildReference)P_TIMEFORMAT)) != null) {
                                            trend.timeFormat = TimeFormat.valueOf((String)s);
                                        }
                                        if ((s = ExporterUtils.getUnionValue((Accessor)ra, (ChildReference)P_VALUEFORMAT)) != null) {
                                            trend.valueFormat = ValueFormat.valueOf((String)s);
                                        }
                                        if (milestones != null) {
                                            trend.setMilestones((Bean)milestones);
                                        }
                                        pdfPage = writer.createPage(null);
                                        Graphics2D g2d = pdfPage.createGraphics(true);
                                        try {
                                            Rectangle2D.Double clip = new Rectangle2D.Double(0.0, 0.0, pdfPage.getWidth(), pdfPage.getHeight());
                                            g2d.setClip(clip);
                                            g2d.scale(0.25, 0.25);
                                            trend.autoscale(true, true);
                                            trend.zoomOut();
                                            trend.layout();
                                            trend.render(g2d);
                                        }
                                        finally {
                                            trend.cleanup();
                                            g2d.dispose();
                                            cs.history.close();
                                        }
                                    }
                                    catch (ExportException e) {
                                        error[0] = e;
                                        cctx.dispose();
                                        if (pdfPage == null) break block20;
                                        try {
                                            pdfPage.close();
                                        }
                                        catch (ExportException e2) {
                                            if (error[0] == null) {
                                                error[0] = e2;
                                            }
                                        }
                                    }
                                }
                                finally {
                                    block21: {
                                        cctx.dispose();
                                        if (pdfPage != null) {
                                            try {
                                                pdfPage.close();
                                            }
                                            catch (ExportException e) {
                                                if (error[0] != null) break block21;
                                                error[0] = e;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    });
                    if (error[0] == null) continue;
                    throw error[0];
                }
            }
            catch (DatabaseException e) {
                throw new ExportException((Throwable)e);
            }
            catch (AccessorConstructionException e) {
                throw new ExportException((Throwable)e);
            }
        }
        finally {
            workerThread.stopDispatchingEvents(true);
        }
    }

    public RecordType options(ExportContext context, Collection<String> content) throws ExportException {
        RecordType options = super.options(context, content);
        options.addComponent(S_CHART, (Datatype)chartOptions);
        return options;
    }

    public void fillDefaultPrefs(ExportContext ctx, Variant options) throws ExportException {
        super.fillDefaultPrefs(ctx, options);
        try {
            RecordAccessor ra = (RecordAccessor)Accessors.getAccessor((Variant)options);
            IEclipsePreferences instPrefs = InstanceScope.INSTANCE.getNode("org.simantics.charts");
            IEclipsePreferences defaultPrefs = DefaultScope.INSTANCE.getNode("org.simantics.charts");
            String s = ExporterUtils.getPrefString((Preferences)instPrefs, (Preferences)defaultPrefs, (String)"chart.item_placement");
            ExporterUtils.setUnionValue((Accessor)ra, (ChildReference)P_ITEMPLACEMENT, (String)s);
            s = ExporterUtils.getPrefString((Preferences)instPrefs, (Preferences)defaultPrefs, (String)"chart.timeformat");
            ExporterUtils.setUnionValue((Accessor)ra, (ChildReference)P_TIMEFORMAT, (String)s);
            s = ExporterUtils.getPrefString((Preferences)instPrefs, (Preferences)defaultPrefs, (String)"chart.valueformat");
            ExporterUtils.setUnionValue((Accessor)ra, (ChildReference)P_VALUEFORMAT, (String)s);
        }
        catch (AccessorConstructionException e) {
            throw new ExportException((Throwable)e);
        }
    }

    public void savePref(Variant options, Preferences contentScopeNode, Preferences workbenchScopeNode) throws ExportException {
        super.savePref(options, contentScopeNode, workbenchScopeNode);
        try {
            RecordAccessor ra = (RecordAccessor)Accessors.getAccessor((Variant)options);
            String s = ExporterUtils.getUnionValue((Accessor)ra, (ChildReference)P_ITEMPLACEMENT);
            ExporterUtils.setPrefString((Preferences)contentScopeNode, (String)"chart.item_placement", (String)s);
            ExporterUtils.setPrefString((Preferences)workbenchScopeNode, (String)"chart.item_placement", (String)s);
            s = ExporterUtils.getUnionValue((Accessor)ra, (ChildReference)P_TIMEFORMAT);
            ExporterUtils.setPrefString((Preferences)contentScopeNode, (String)"chart.timeformat", (String)s);
            ExporterUtils.setPrefString((Preferences)workbenchScopeNode, (String)"chart.timeformat", (String)s);
            s = ExporterUtils.getUnionValue((Accessor)ra, (ChildReference)P_VALUEFORMAT);
            ExporterUtils.setPrefString((Preferences)contentScopeNode, (String)"chart.valueformat", (String)s);
            ExporterUtils.setPrefString((Preferences)workbenchScopeNode, (String)"chart.valueformat", (String)s);
        }
        catch (AccessorConstructionException e) {
            throw new ExportException((Throwable)e);
        }
    }

    public void loadPref(Variant options, Preferences contentScopeNode, Preferences workbenchScopeNode) throws ExportException {
        super.loadPref(options, contentScopeNode, workbenchScopeNode);
        try {
            RecordAccessor ra = (RecordAccessor)Accessors.getAccessor((Variant)options);
            String s = ExporterUtils.getPrefString((Preferences)contentScopeNode, (String)"chart.item_placement");
            if (s == null) {
                s = ExporterUtils.getPrefString((Preferences)workbenchScopeNode, (String)"chart.item_placement");
            }
            ExporterUtils.setUnionValue((Accessor)ra, (ChildReference)P_ITEMPLACEMENT, (String)s);
            s = ExporterUtils.getPrefString((Preferences)contentScopeNode, (String)"chart.timeformat");
            if (s == null) {
                s = ExporterUtils.getPrefString((Preferences)workbenchScopeNode, (String)"chart.timeformat");
            }
            ExporterUtils.setUnionValue((Accessor)ra, (ChildReference)P_TIMEFORMAT, (String)s);
            s = ExporterUtils.getPrefString((Preferences)contentScopeNode, (String)"chart.valueformat");
            if (s == null) {
                s = ExporterUtils.getPrefString((Preferences)workbenchScopeNode, (String)"chart.valueformat");
            }
            ExporterUtils.setUnionValue((Accessor)ra, (ChildReference)P_VALUEFORMAT, (String)s);
        }
        catch (AccessorConstructionException e) {
            throw new ExportException((Throwable)e);
        }
    }

    public List<String> validate(String contentUri, ExportContext context, Variant options) {
        return Collections.emptyList();
    }

    static class ChartSettings {
        Resource chartRes;
        ExperimentExportClass.ModelRef modelRef;
        ExperimentExportClass.ExperimentRef experimentRef;
        ExperimentExportClass.RunRef runRef;
        HistoryManager history;

        ChartSettings() {
        }
    }
}

