/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.editor;

import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import org.eclipse.core.commands.IStateListener;
import org.eclipse.core.commands.State;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.contexts.IContextService;
import org.simantics.Simantics;
import org.simantics.browsing.ui.model.browsecontexts.BrowseContext;
import org.simantics.charts.Activator;
import org.simantics.charts.ITrendSupport;
import org.simantics.charts.editor.ActiveRunQuery;
import org.simantics.charts.editor.ChartData;
import org.simantics.charts.editor.ChartKeyBindings;
import org.simantics.charts.editor.ChartKeys;
import org.simantics.charts.editor.ChartPasteHandler2;
import org.simantics.charts.editor.ChartPreferencesAction;
import org.simantics.charts.editor.HideItemsAction;
import org.simantics.charts.editor.MoveHairlineAction;
import org.simantics.charts.editor.PropertiesAction;
import org.simantics.charts.editor.SendCommandAction;
import org.simantics.charts.editor.SubscriptionDropParticipant;
import org.simantics.charts.editor.TrackExperimentTimeAction;
import org.simantics.charts.ontology.ChartResource;
import org.simantics.charts.preference.ChartPreferences;
import org.simantics.charts.query.FindChartItemForTrendItem;
import org.simantics.charts.query.MilestoneSpecQuery;
import org.simantics.charts.query.SetProperty;
import org.simantics.charts.query.TrendSpecQuery;
import org.simantics.charts.ui.ChartLinkData;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.util.Bean;
import org.simantics.databoard.util.ObjectUtils;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.ParametrizedRead;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.exception.MissingVariableException;
import org.simantics.db.layer0.request.Model;
import org.simantics.db.layer0.request.PossibleActiveExperiment;
import org.simantics.db.layer0.request.combinations.Combinators;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.RVIBuilder;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.procedure.AsyncListener;
import org.simantics.db.procedure.SyncListener;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.Write;
import org.simantics.diagram.participant.ContextUtil;
import org.simantics.diagram.participant.SGFocusParticipant;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.CanvasContext;
import org.simantics.g2d.chassis.AWTChassis;
import org.simantics.g2d.chassis.ICanvasChassis;
import org.simantics.g2d.chassis.IChassisListener;
import org.simantics.g2d.chassis.SWTChassis;
import org.simantics.g2d.participant.KeyToCommand;
import org.simantics.g2d.participant.TimeParticipant;
import org.simantics.g2d.utils.CanvasUtils;
import org.simantics.history.Collector;
import org.simantics.history.HistoryManager;
import org.simantics.history.impl.FileHistory;
import org.simantics.project.IProject;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.events.Event;
import org.simantics.scenegraph.g2d.events.EventTypes;
import org.simantics.scenegraph.g2d.events.IEventHandler;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.g2d.events.command.Command;
import org.simantics.scenegraph.g2d.events.command.Commands;
import org.simantics.selectionview.StandardPropertyPage;
import org.simantics.simulation.data.Datasource;
import org.simantics.simulation.experiment.ExperimentState;
import org.simantics.simulation.experiment.IExperiment;
import org.simantics.simulation.experiment.IExperimentListener;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.trend.TrendInitializer;
import org.simantics.trend.configuration.ItemPlacement;
import org.simantics.trend.configuration.LineQuality;
import org.simantics.trend.configuration.TimeFormat;
import org.simantics.trend.configuration.TrendSpec;
import org.simantics.trend.impl.HorizRuler;
import org.simantics.trend.impl.ItemNode;
import org.simantics.trend.impl.MilestoneSpec;
import org.simantics.trend.impl.TrendNode;
import org.simantics.trend.impl.TrendParticipant;
import org.simantics.ui.workbench.IPropertyPage;
import org.simantics.ui.workbench.IResourceEditorInput;
import org.simantics.ui.workbench.ResourceEditorPart;
import org.simantics.ui.workbench.action.PerformDefaultAction;
import org.simantics.ui.workbench.editor.input.InputValidationCombinators;
import org.simantics.utils.datastructures.hints.HintListenerAdapter;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintListener;
import org.simantics.utils.datastructures.hints.IHintObservable;
import org.simantics.utils.format.ValueFormat;
import org.simantics.utils.threads.AWTThread;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.SWTThread;
import org.simantics.utils.threads.ThreadUtils;
import org.simantics.utils.ui.BundleUtils;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.ExceptionUtils;
import org.simantics.utils.ui.SWTDPIUtil;
import org.simantics.utils.ui.SWTUtils;
import org.simantics.utils.ui.dialogs.ShowMessage;
import org.simantics.utils.ui.jface.ActiveSelectionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeSeriesEditor
extends ResourceEditorPart {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeSeriesEditor.class);
    ParametrizedRead<IResourceEditorInput, Boolean> INPUT_VALIDATOR = Combinators.compose((ParametrizedRead)InputValidationCombinators.hasURI(), (ParametrizedRead)InputValidationCombinators.extractInputResource());
    private static String ROOT_PROPERTY_BROWSE_CONTEXT = "http://www.simantics.org/Charts-1.2/ChartBrowseContext";
    public static final String ID = "org.simantics.charts.editor.timeseries";
    private static final String CONTEXT_MENU_ID = "#timeSeriesChart";
    private IEclipsePreferences chartPreferenceNode;
    private final ImageDescriptor IMG_ZOOM_TO_FIT = BundleUtils.getImageDescriptorFromPlugin((String)"org.simantics.charts", (String)"icons/horizAndVert16.png");
    private final ImageDescriptor IMG_ZOOM_TO_FIT_HORIZ = BundleUtils.getImageDescriptorFromPlugin((String)"org.simantics.charts", (String)"icons/horiz16.png");
    private final ImageDescriptor IMG_ZOOM_TO_FIT_VERT = BundleUtils.getImageDescriptorFromPlugin((String)"org.simantics.charts", (String)"icons/vert16.png");
    private final ImageDescriptor IMG_AUTOSCALE = BundleUtils.getImageDescriptorFromPlugin((String)"org.simantics.charts", (String)"icons/autoscale16.png");
    IEclipsePreferences.IPreferenceChangeListener preferenceListener = new IEclipsePreferences.IPreferenceChangeListener(){

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            String s;
            ValueFormat vf;
            String s2;
            TimeFormat tf;
            if (TimeSeriesEditor.this.disposed) {
                System.err.println("Warning: pref change to disposed TimeSeriesEditor");
                return;
            }
            if (event.getKey().equals("chart.redraw_interval") || event.getKey().equals("chart.autoscale_interval")) {
                long redraw_interval = TimeSeriesEditor.this.chartPreferenceNode.getLong("chart.redraw_interval", ChartPreferences.DEFAULT_REDRAW_INTERVAL.longValue());
                long autoscale_interval = TimeSeriesEditor.this.chartPreferenceNode.getLong("chart.autoscale_interval", ChartPreferences.DEFAULT_AUTOSCALE_INTERVAL.longValue());
                TimeSeriesEditor.this.setInterval(redraw_interval, autoscale_interval);
            }
            if (event.getKey().equals("chart.draw_samples")) {
                boolean draw_samples = TimeSeriesEditor.this.chartPreferenceNode.getBoolean("chart.draw_samples", ChartPreferences.DEFAULT_DRAW_SAMPLES.booleanValue());
                TimeSeriesEditor.this.setDrawSamples(draw_samples);
            }
            if (event.getKey().equals("chart.timeformat") && (tf = TimeFormat.valueOf((String)(s2 = TimeSeriesEditor.this.chartPreferenceNode.get("chart.timeformat", ChartPreferences.DEFAULT_TIMEFORMAT)))) != null) {
                TimeSeriesEditor.this.setTimeFormat(tf);
            }
            if (event.getKey().equals("chart.valueformat") && (vf = ValueFormat.valueOf((String)(s = TimeSeriesEditor.this.chartPreferenceNode.get("chart.valueformat", "Default")))) != null) {
                TimeSeriesEditor.this.setValueFormat(vf);
            }
            if (event.getKey().equals("chart.valueformat.decimal.digits")) {
                TimeSeriesEditor.this.setNumberOfDecimals(TimeSeriesEditor.this.chartPreferenceNode.getInt("chart.valueformat.decimal.digits", 7));
            }
            if (event.getKey().equals("chart.item_placement")) {
                String s3 = TimeSeriesEditor.this.chartPreferenceNode.get("chart.item_placement", "Overlapping");
                ItemPlacement ip = ItemPlacement.valueOf((String)s3);
                if (TimeSeriesEditor.this.trendNode != null) {
                    TimeSeriesEditor.this.trendNode.itemPlacement = ip;
                }
            }
            if (event.getKey().equals("chart.textquality") || event.getKey().equals("chart.linequality")) {
                String s1 = TimeSeriesEditor.this.chartPreferenceNode.get("chart.textquality", ChartPreferences.DEFAULT_TEXTQUALITY);
                String s22 = TimeSeriesEditor.this.chartPreferenceNode.get("chart.linequality", ChartPreferences.DEFAULT_LINEQUALITY);
                LineQuality q1 = LineQuality.valueOf((String)s1);
                LineQuality q2 = LineQuality.valueOf((String)s22);
                if (TimeSeriesEditor.this.trendNode != null) {
                    TimeSeriesEditor.this.trendNode.quality.textQuality = q1;
                }
                if (TimeSeriesEditor.this.trendNode != null) {
                    TimeSeriesEditor.this.trendNode.quality.lineQuality = q2;
                }
            }
        }
    };
    IProject project;
    Resource model;
    Text errorText;
    UUID uniqueChartEditorId = UUID.randomUUID();
    Display display;
    SWTChassis canvas;
    CanvasContext cvsCtx;
    TrendParticipant tp;
    TrendNode trendNode;
    TrendInitializer.StepListener stepListener;
    MilestoneSpecListener milestoneListener;
    MilestoneSpecQuery milestoneQuery;
    final ChartData chartData = new ChartData(null, null, null, null, null, null);
    ChartKeys.ChartSourceKey chartDataKey;
    protected IThreadWorkQueue swt;
    protected ContextUtil contextUtil;
    ExperimentStateListener experimentStateListener = new ExperimentStateListener();
    ChartDataListener chartDataListener = new ChartDataListener();
    ValueTipBoxPositionListener valueTipBoxPositionListener = new ValueTipBoxPositionListener();
    State linkTimeState;
    IStateListener linkTimeStateListener = new IStateListener(){

        public void handleStateChange(State state, Object oldValue) {
            final ChartLinkData newData = (ChartLinkData)TimeSeriesEditor.this.linkTimeState.getValue();
            boolean bl = TimeSeriesEditor.this.trendNode.autoscaletime = newData == null || newData.sender == TimeSeriesEditor.this;
            if (newData == null || newData.sender == TimeSeriesEditor.this) {
                return;
            }
            TrendNode tn = TimeSeriesEditor.this.trendNode;
            HorizRuler hr = tn != null ? tn.horizRuler : null;
            ChartLinkData oldData = new ChartLinkData();
            TimeSeriesEditor.this.getFromEnd(oldData);
            if (hr != null && !ObjectUtils.objectEquals((Object)tn.valueTipTime, (Object)newData.valueTipTime)) {
                tn.valueTipTime = newData.valueTipTime;
                TimeSeriesEditor.this.tp.setDirty();
            }
            if (hr != null && (oldData.from != newData.from || oldData.sx != newData.sx)) {
                TimeSeriesEditor.this.cvsCtx.getThreadAccess().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        boolean b = (this).TimeSeriesEditor.this.trendNode.horizRuler.setFromScale(newData.from, newData.sx);
                        (this).TimeSeriesEditor.this.trendNode.horizRuler.autoscroll = false;
                        if (b) {
                            (this).TimeSeriesEditor.this.trendNode.layout();
                            (this).TimeSeriesEditor.this.tp.setDirty();
                        }
                    }
                });
            }
        }
    };
    HorizRuler.TimeWindowListener horizRulerListener = new HorizRuler.TimeWindowListener(){

        public void onNewWindow(double from, double end, double scalex) {
            ChartLinkData oldData = (ChartLinkData)TimeSeriesEditor.this.linkTimeState.getValue();
            if (oldData != null) {
                ChartLinkData data = new ChartLinkData((Object)TimeSeriesEditor.this, from, end, scalex);
                data.valueTipTime = TimeSeriesEditor.this.trendNode.valueTipTime;
                TimeSeriesEditor.this.linkTimeState.setValue((Object)data);
            }
        }
    };
    ActiveSelectionProvider selectionProvider = new ActiveSelectionProvider();
    MenuManager menuManager;

    protected ParametrizedRead<IResourceEditorInput, Boolean> getInputValidator() {
        return this.INPUT_VALIDATOR;
    }

    boolean isTimeLinked() {
        if (this.linkTimeState == null) {
            return false;
        }
        Boolean isLinked = (Boolean)this.linkTimeState.getValue();
        return isLinked != null && isLinked != false;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        try {
            this.model = (Resource)Simantics.getSession().syncRequest((Read)new Model(this.getInputResource()));
            this.chartDataKey = ChartKeys.chartSourceKey(this.model);
        }
        catch (DatabaseException e) {
            throw new PartInitException((IStatus)new Status(4, "org.simantics.charts", "Input " + String.valueOf(this.getInputResource()) + " is not part of a model.", (Throwable)e));
        }
    }

    protected void setCanvasContext(final SWTChassis chassis, final ICanvasContext context) {
        chassis.getAWTComponent().setCanvasContext(context);
        SWTUtils.asyncExec((Widget)chassis, (Runnable)new Runnable(){

            @Override
            public void run() {
                if (!chassis.isDisposed()) {
                    chassis.setCanvasContext(context);
                }
            }
        });
    }

    public void createPartControl(Composite parent) {
        this.display = parent.getDisplay();
        this.swt = SWTThread.getThreadAccess((Display)this.display);
        this.project = Simantics.peekProject();
        if (this.project == null) {
            this.errorText = new Text(parent, 0);
            this.errorText.setText("No project is open.");
            this.errorText.setEditable(false);
            return;
        }
        IThreadWorkQueue thread = AWTThread.getThreadAccess();
        this.cvsCtx = new CanvasContext(thread);
        this.cvsCtx.setLocked(true);
        IWorkbenchWindow win = this.getEditorSite().getWorkbenchWindow();
        IWorkbenchPage page = this.getEditorSite().getPage();
        this.canvas = new SWTChassis(parent, 0);
        this.canvas.populate(parameter -> {
            if (!this.disposed) {
                this.canvas.addChassisListener((IChassisListener)new ChassisListener());
                this.initializeCanvas(this.canvas, this.cvsCtx, win, page);
            }
        });
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        org.eclipse.core.commands.Command command = service.getCommand("org.simantics.charts.linktime");
        this.linkTimeState = command.getState("org.simantics.charts.linktime.state");
        if (this.linkTimeState != null) {
            this.linkTimeState.addListener(this.linkTimeStateListener);
        }
        this.addPopupMenu();
        this.activateValidation();
        this.selectionProvider.setSelection((ISelection)new StructuredSelection((Object)this.getInputResource()));
        this.getSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
    }

    protected void initializeCanvas(final SWTChassis chassis, CanvasContext cvsCtx, IWorkbenchWindow window, IWorkbenchPage page) {
        TrendSpec nodata = new TrendSpec();
        nodata.init();
        cvsCtx = TrendInitializer.defaultInitializeCanvas((CanvasContext)cvsCtx, null, null, null, (TrendSpec)nodata);
        this.tp = (TrendParticipant)cvsCtx.getAtMostOneItemOfClass(TrendParticipant.class);
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        this.contextUtil = new ContextUtil(contextService, this.swt);
        cvsCtx.add((Object)new SubscriptionDropParticipant(this.getInputResource()));
        cvsCtx.add((Object)new KeyToCommand(ChartKeyBindings.DEFAULT_BINDINGS));
        cvsCtx.add((Object)new ChartPasteHandler2((Resource)this.getInputResource().get()));
        cvsCtx.add((Object)this.contextUtil);
        cvsCtx.add((Object)new SGFocusParticipant(this.canvas, "org.simantics.charts.editor.context"));
        this.stepListener = new TrendInitializer.StepListener(this.tp);
        this.trendNode = this.tp.getTrend();
        this.trendNode.titleNode.remove();
        this.trendNode.titleNode = null;
        this.trendNode.horizRuler.listener = this.horizRulerListener;
        ChartLinkData linkTime = (ChartLinkData)this.linkTimeState.getValue();
        if (linkTime != null) {
            this.trendNode.horizRuler.setFromEnd(linkTime.from, linkTime.sx);
        }
        cvsCtx.getEventHandlerStack().add((Object)new IEventHandler(){

            public int getEventMask() {
                return EventTypes.MouseMovedMask | EventTypes.MouseClickMask | EventTypes.CommandMask | 4;
            }

            public boolean handleEvent(Event e) {
                ChartLinkData oldData = (ChartLinkData)TimeSeriesEditor.this.linkTimeState.getValue();
                if (oldData != null) {
                    ChartLinkData newData = new ChartLinkData();
                    TimeSeriesEditor.this.getFromEnd(newData);
                    if (!newData.equals(oldData)) {
                        TimeSeriesEditor.this.linkTimeState.setValue((Object)newData);
                    }
                }
                return false;
            }
        }, -1);
        this.canvas.getHintContext().setHint(SWTChassis.KEY_EDITORPART, (Object)this);
        this.canvas.getHintContext().setHint(SWTChassis.KEY_WORKBENCHPAGE, (Object)page);
        this.canvas.getHintContext().setHint(SWTChassis.KEY_WORKBENCHWINDOW, (Object)window);
        cvsCtx.setLocked(false);
        this.setCanvasContext(chassis, (ICanvasContext)cvsCtx);
        cvsCtx.getEventHandlerStack().add((Object)new IEventHandler(){

            public boolean handleEvent(Event e) {
                MouseEvent.MouseButtonReleasedEvent event = (MouseEvent.MouseButtonReleasedEvent)e;
                if (event.button != 2) {
                    return false;
                }
                Point p = new Point(SWTDPIUtil.downscaleSwt((int)((int)event.screenPosition.getX())), SWTDPIUtil.downscaleSwt((int)((int)event.screenPosition.getY())));
                SWTUtils.asyncExec((Widget)chassis, () -> {
                    if (!TimeSeriesEditor.this.canvas.isDisposed()) {
                        TimeSeriesEditor.this.showPopup(p);
                    }
                });
                return true;
            }

            public int getEventMask() {
                return EventTypes.MouseButtonReleasedMask;
            }
        }, 1000000);
        this.project.addHintListener((IHintListener)this.chartDataListener);
        this.chartData.readFrom((ChartData)this.project.getHint((IHintContext.Key)this.chartDataKey));
        this.chartData.reference();
        if (this.chartData.run != null) {
            this.milestoneListener = new MilestoneSpecListener();
            this.milestoneQuery = new MilestoneSpecQuery(this.chartData.run);
            this.getSession().asyncRequest((Read)this.milestoneQuery, (AsyncListener)this.milestoneListener);
        }
        this.trackChartConfiguration();
        this.trackPreferences();
        cvsCtx.getHintStack().addHintListener((IHintListener)this.valueTipBoxPositionListener);
    }

    private void addPopupMenu() {
        this.menuManager = new MenuManager("Time Series Editor", CONTEXT_MENU_ID);
        this.menuManager.setRemoveAllWhenShown(true);
        Menu menu = this.menuManager.createContextMenu((Control)this.canvas);
        this.canvas.setMenu(menu);
        this.getEditorSite().registerContextMenu(this.menuManager.getId(), this.menuManager, (ISelectionProvider)this.selectionProvider);
        this.menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                boolean hairlineMovementAllowed;
                TrendNode trendNode = TimeSeriesEditor.this.trendNode;
                TrendParticipant tp = TimeSeriesEditor.this.tp;
                if (trendNode == null || tp == null) {
                    return;
                }
                TrendSpec trendSpec = trendNode.getTrendSpec();
                ItemNode hoverItem = tp.hoveringItem;
                Resource chart = TimeSeriesEditor.this.getInputResource();
                Resource chartItem = null;
                Resource component = null;
                if (hoverItem != null && hoverItem.item != null) {
                    component = TimeSeriesEditor.this.resolveReferencedComponent(TimeSeriesEditor.this.getResourceInput(), hoverItem.item.variableId);
                    if (chart != null) {
                        try {
                            chartItem = (Resource)TimeSeriesEditor.this.getSession().sync((ReadInterface)new FindChartItemForTrendItem(chart, hoverItem.item));
                        }
                        catch (DatabaseException e) {
                            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.charts", "Failed to resolve chart item based on hovered item.", (Throwable)e));
                        }
                    }
                }
                boolean bl = hairlineMovementAllowed = !trendSpec.experimentIsRunning || !trendSpec.viewProfile.trackExperimentTime;
                if (component != null || chartItem != null) {
                    manager.add((IContributionItem)new Separator());
                    if (component != null) {
                        manager.add((IAction)new PerformDefaultAction("Show Referenced Component", (Control)TimeSeriesEditor.this.canvas, (Object)component));
                    }
                    if (chartItem != null) {
                        manager.add((IAction)new HideItemsAction("Hide Item", true, Collections.singletonList(chartItem)));
                    }
                }
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)new MoveHairlineAction("Move Hairline Here", chart, hairlineMovementAllowed && Double.isFinite(trendNode.mouseHoverTime), trendNode, trendNode.mouseHoverTime));
                manager.add((IAction)new MoveHairlineAction("Move Hairline To Current Time", chart, hairlineMovementAllowed, trendNode, trendNode.horizRuler.getItemEndTime(), Boolean.FALSE));
                manager.add((IAction)new TrackExperimentTimeAction("Hairline Tracks Current Time", chart, trendSpec.viewProfile.trackExperimentTime));
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)new SendCommandAction("Zoom to Fit", TimeSeriesEditor.this.IMG_ZOOM_TO_FIT, (ICanvasContext)TimeSeriesEditor.this.cvsCtx, Commands.ZOOM_TO_FIT));
                manager.add((IAction)new SendCommandAction("Zoom to Fit Horizontally", TimeSeriesEditor.this.IMG_ZOOM_TO_FIT_HORIZ, (ICanvasContext)TimeSeriesEditor.this.cvsCtx, Commands.ZOOM_TO_FIT_HORIZ));
                manager.add((IAction)new SendCommandAction("Zoom to Fit Vertically", TimeSeriesEditor.this.IMG_ZOOM_TO_FIT_VERT, (ICanvasContext)TimeSeriesEditor.this.cvsCtx, Commands.ZOOM_TO_FIT_VERT));
                manager.add((IAction)new SendCommandAction("Autoscale Chart", TimeSeriesEditor.this.IMG_AUTOSCALE, (ICanvasContext)TimeSeriesEditor.this.cvsCtx, Commands.AUTOSCALE));
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)new ChartPreferencesAction((IShellProvider)TimeSeriesEditor.this.getSite()));
                manager.add((IContributionItem)new Separator());
                if (chartItem != null) {
                    manager.add((IAction)new PropertiesAction("Item Properties", (Control)TimeSeriesEditor.this.canvas, chartItem));
                }
                manager.add((IAction)new PropertiesAction("Chart Properties", (Control)TimeSeriesEditor.this.canvas, chart));
            }
        });
    }

    protected Resource resolveReferencedComponent(IResourceEditorInput resourceInput, final String variableId) {
        if (variableId == null || variableId.isBlank()) {
            return null;
        }
        try {
            return (Resource)this.getSession().sync((ReadInterface)new UniqueRead<Resource>(){

                private Resource findFirstParentRepresentation(ReadGraph graph, Variable var) throws DatabaseException {
                    while (var != null) {
                        Resource rep = var.getPossibleRepresents(graph);
                        if (rep != null) {
                            return rep;
                        }
                        var = var.getParent(graph);
                    }
                    return null;
                }

                public Resource perform(ReadGraph graph) throws DatabaseException {
                    Resource input = TimeSeriesEditor.this.getInputResource();
                    Resource root = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(input));
                    if (root == null) {
                        return null;
                    }
                    Variable configuration = Variables.getConfigurationContext((ReadGraph)graph, (Resource)root);
                    Resource run = (Resource)graph.sync((ReadInterface)new PossibleActiveExperiment(TimeSeriesEditor.this.model));
                    Variable experimentContext = run != null ? Variables.getPossibleVariable((ReadGraph)graph, (Resource)run) : null;
                    RVI rvi = RVI.fromResourceFormat((RequestProcessor)graph, (String)variableId);
                    if ((rvi = new RVIBuilder(rvi).removeFromFirstRole(Variables.Role.PROPERTY).toRVI()).isEmpty()) {
                        return null;
                    }
                    try {
                        Variable var = rvi.resolve(graph, experimentContext != null ? experimentContext : configuration);
                        return this.findFirstParentRepresentation(graph, var);
                    }
                    catch (MissingVariableException e) {
                        LOGGER.debug("Invalid RVI {} for currently active context", (Object)rvi, (Object)e);
                        return null;
                    }
                }
            });
        }
        catch (DatabaseException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.charts", "Failed to resolve referenced component from input " + String.valueOf(this.getEditorInput()) + "and variableId " + variableId, (Throwable)e));
            return null;
        }
    }

    private void showPopup(Point p) {
        this.menuManager.getMenu().setLocation(p);
        this.menuManager.getMenu().setVisible(true);
    }

    private void trackChartConfiguration() {
        this.getSession().asyncRequest((Read)new TrendSpecQuery(this.uniqueChartEditorId, this.getInputResource()), (AsyncListener)new TrendSpecListener());
        this.getSession().asyncRequest((Read)new ActiveRunQuery(this.uniqueChartEditorId, this.getInputResource()), (SyncListener)new ActiveRunListener());
    }

    public void setFocus() {
        if (this.errorText != null) {
            this.errorText.setFocus();
        } else {
            this.canvas.setFocus();
        }
    }

    public void dispose() {
        MilestoneSpecListener ml;
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        if (this.trendNode != null && this.trendNode.horizRuler != null) {
            this.trendNode.horizRuler.listener = null;
        }
        if (this.linkTimeState != null) {
            this.linkTimeState.removeListener(this.linkTimeStateListener);
        }
        this.canvas.getHintContext().removeHint(SWTChassis.KEY_EDITORPART);
        this.canvas.getHintContext().removeHint(SWTChassis.KEY_WORKBENCHPAGE);
        this.canvas.getHintContext().removeHint(SWTChassis.KEY_WORKBENCHWINDOW);
        if (this.chartPreferenceNode != null) {
            this.chartPreferenceNode.removePreferenceChangeListener(this.preferenceListener);
        }
        if ((ml = this.milestoneListener) != null) {
            ml.dispose();
        }
        if (this.project != null) {
            this.project.removeHintListener((IHintListener)this.chartDataListener);
        }
        if (this.chartData != null) {
            if (this.chartData.datasource != null) {
                this.chartData.datasource.removeListener((Datasource.DatasourceListener)this.stepListener);
            }
            if (this.chartData.experiment != null) {
                this.chartData.experiment.removeListener((IExperimentListener)this.experimentStateListener);
            }
            this.chartData.dereference();
            this.chartData.readFrom(null);
        }
        super.dispose();
    }

    public void setInput(ChartData data, TrendSpec newSpec) {
        Resource oldExperimentResource;
        Collector newCollector;
        IExperiment newExperiment;
        Datasource newDatasource;
        boolean doLayout = false;
        if (data != null && data.model != null && !data.model.equals(this.model)) {
            data = null;
        }
        Datasource oldDatasource = this.chartData == null ? null : this.chartData.datasource;
        Datasource datasource = newDatasource = data == null ? null : data.datasource;
        if (oldDatasource != null) {
            oldDatasource.removeListener((Datasource.DatasourceListener)this.stepListener);
        }
        if (newDatasource != null) {
            newDatasource.addListener((Datasource.DatasourceListener)this.stepListener);
        }
        IExperiment oldExperiment = this.chartData == null ? null : this.chartData.experiment;
        IExperiment iExperiment = newExperiment = data == null ? null : data.experiment;
        if (oldExperiment != null) {
            oldExperiment.removeListener((IExperimentListener)this.experimentStateListener);
        }
        if (newExperiment != null) {
            newExperiment.addListener((IExperimentListener)this.experimentStateListener);
        }
        HistoryManager oldHistorian = this.trendNode.historian == null ? null : this.trendNode.historian;
        HistoryManager newHistorian = data == null ? null : data.history;
        Collector collector = newCollector = data == null ? null : data.collector;
        if (newHistorian instanceof FileHistory) {
            FileHistory fh = (FileHistory)newHistorian;
            LOGGER.info("History = {}", (Object)fh.getWorkarea());
        }
        this.trendNode.setHistorian(newHistorian, newCollector);
        doLayout |= this.trendNode.autoscale(true, true) | !ObjectUtils.objectEquals((Object)oldHistorian, (Object)newHistorian);
        TrendSpec oldSpec = this.trendNode.getTrendSpec();
        if (!newSpec.equals((Object)oldSpec)) {
            this.trendNode.setTrendSpec(newSpec == null ? TrendSpec.EMPTY : newSpec);
            doLayout = true;
        }
        Resource newExperimentResource = data == null ? null : data.run;
        Resource resource = oldExperimentResource = this.chartData == null ? null : this.chartData.run;
        if (!ObjectUtils.objectEquals((Object)oldExperimentResource, (Object)newExperimentResource)) {
            if (this.milestoneListener != null) {
                this.milestoneListener.dispose();
                this.milestoneListener = null;
            }
            if (this.milestoneQuery != null) {
                this.milestoneQuery = null;
            }
            this.trendNode.setMilestones((Bean)MilestoneSpec.EMPTY);
            if (newExperimentResource != null) {
                this.milestoneListener = new MilestoneSpecListener();
                this.milestoneQuery = new MilestoneSpecQuery(newExperimentResource);
                Simantics.getSession().asyncRequest((Read)this.milestoneQuery, (AsyncListener)this.milestoneListener);
            }
        }
        if (doLayout) {
            this.trendNode.layout();
        }
        this.chartData.dereference();
        this.chartData.readFrom(data);
        this.chartData.reference();
        this.tp.setDirty();
        if (!ObjectUtils.objectEquals((Object)oldExperimentResource, (Object)newExperimentResource)) {
            this.resetViewAfterDataChange();
        }
    }

    private void trackPreferences() {
        this.chartPreferenceNode = InstanceScope.INSTANCE.getNode("org.simantics.charts");
        this.chartPreferenceNode.addPreferenceChangeListener(this.preferenceListener);
        long redrawInterval = this.chartPreferenceNode.getLong("chart.redraw_interval", ChartPreferences.DEFAULT_REDRAW_INTERVAL.longValue());
        long autoscaleInterval = this.chartPreferenceNode.getLong("chart.autoscale_interval", ChartPreferences.DEFAULT_AUTOSCALE_INTERVAL.longValue());
        this.setInterval(redrawInterval, autoscaleInterval);
        String timeFormat = this.chartPreferenceNode.get("chart.timeformat", ChartPreferences.DEFAULT_TIMEFORMAT);
        TimeFormat tf = TimeFormat.valueOf((String)timeFormat);
        if (tf != null) {
            this.setTimeFormat(tf);
        }
        Boolean drawSamples = this.chartPreferenceNode.getBoolean("chart.draw_samples", ChartPreferences.DEFAULT_DRAW_SAMPLES.booleanValue());
        this.setDrawSamples(drawSamples);
        String valueFormat = this.chartPreferenceNode.get("chart.valueformat", "Default");
        ValueFormat vf = ValueFormat.valueOf((String)valueFormat);
        if (vf != null) {
            this.setValueFormat(vf);
        }
        int significantDigits = this.chartPreferenceNode.getInt("chart.valueformat.decimal.digits", 7);
        this.setNumberOfDecimals(significantDigits);
        String s = this.chartPreferenceNode.get("chart.item_placement", "Overlapping");
        ItemPlacement ip = ItemPlacement.valueOf((String)s);
        if (this.trendNode != null) {
            this.trendNode.itemPlacement = ip;
        }
        String s1 = this.chartPreferenceNode.get("chart.textquality", ChartPreferences.DEFAULT_TEXTQUALITY);
        String s2 = this.chartPreferenceNode.get("chart.linequality", ChartPreferences.DEFAULT_LINEQUALITY);
        LineQuality q1 = LineQuality.valueOf((String)s1);
        LineQuality q2 = LineQuality.valueOf((String)s2);
        if (this.trendNode != null) {
            this.trendNode.quality.textQuality = q1;
        }
        if (this.trendNode != null) {
            this.trendNode.quality.lineQuality = q2;
        }
    }

    private void setInterval(long redrawInterval, long autoscaleInterval) {
        redrawInterval = Math.max(1L, redrawInterval);
        long pulse = Math.min(50L, redrawInterval);
        pulse = Math.min(pulse, autoscaleInterval);
        IHintContext h = this.canvas.getCanvasContext().getDefaultHintContext();
        h.setHint(TimeParticipant.KEY_TIME_PULSE_INTERVAL, (Object)pulse);
        h.setHint(TrendParticipant.KEY_TREND_DRAW_INTERVAL, (Object)redrawInterval);
        h.setHint(TrendParticipant.KEY_TREND_AUTOSCALE_INTERVAL, (Object)autoscaleInterval);
    }

    private void setDrawSamples(boolean value) {
        this.trendNode.drawSamples = value;
        this.trendNode.layout();
        this.tp.setDirty();
    }

    private void setTimeFormat(TimeFormat tf) {
        if (this.trendNode.timeFormat == tf) {
            return;
        }
        this.trendNode.timeFormat = tf;
        this.trendNode.layout();
        this.tp.setDirty();
    }

    private void setValueFormat(ValueFormat vf) {
        if (this.trendNode.valueFormat == vf) {
            return;
        }
        this.trendNode.valueFormat = vf;
        this.trendNode.layout();
        this.tp.setDirty();
    }

    private void setNumberOfDecimals(int decimals) {
        if (this.trendNode.decimals == decimals) {
            return;
        }
        this.trendNode.decimals = decimals;
        this.trendNode.layout();
        this.tp.setDirty();
    }

    public <T> T getAdapter(Class<T> adapter) {
        CanvasContext ctx;
        if (adapter == INode.class && (ctx = this.cvsCtx) != null) {
            return (T)ctx.getSceneGraph();
        }
        if (adapter == IPropertyPage.class) {
            return (T)new StandardPropertyPage(this.getSite(), this.getPropertyPageContexts());
        }
        if (adapter == ICanvasContext.class) {
            return (T)this.cvsCtx;
        }
        return (T)super.getAdapter(adapter);
    }

    protected Set<String> getPropertyPageContexts() {
        try {
            return BrowseContext.getBrowseContextClosure((RequestProcessor)Simantics.getSession(), Collections.singleton(ROOT_PROPERTY_BROWSE_CONTEXT));
        }
        catch (DatabaseException e) {
            ExceptionUtils.logAndShowError((String)"Failed to load modeled browse contexts for property page, see exception for details.", (Throwable)e);
            return Collections.singleton(ROOT_PROPERTY_BROWSE_CONTEXT);
        }
    }

    public void getFromEnd(ChartLinkData data) {
        HorizRuler hr;
        data.sender = this;
        TrendNode tn = this.trendNode;
        data.valueTipTime = tn.valueTipTime;
        HorizRuler horizRuler = hr = tn != null ? tn.horizRuler : null;
        if (hr != null) {
            data.from = hr.from;
            data.end = hr.end;
            double len = hr.end - hr.from;
            double wid = tn.plot.getWidth();
            if (wid == 0.0) {
                wid = 0.1;
            }
            data.sx = len / wid;
        }
    }

    private static boolean doubleEquals(double a, double b) {
        if (Double.isNaN(a) && Double.isNaN(b)) {
            return true;
        }
        return a == b;
    }

    protected void resetViewAfterDataChange() {
        CanvasUtils.sendCommand((ICanvasContext)this.cvsCtx, (Command)Commands.CANCEL);
        CanvasUtils.sendCommand((ICanvasContext)this.cvsCtx, (Command)Commands.AUTOSCALE);
    }

    class ActiveRunListener
    implements SyncListener<Resource> {
        ActiveRunListener() {
        }

        public void exception(ReadGraph graph, Throwable throwable) {
            ErrorLogger.defaultLogError((Throwable)throwable);
            ShowMessage.showError((String)throwable.getClass().getSimpleName(), (String)throwable.getMessage());
        }

        public void execute(ReadGraph graph, Resource run) throws DatabaseException {
            if (run != null) {
                ITrendSupport ts;
                SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
                Variable var = Variables.getPossibleVariable((ReadGraph)graph, (Resource)run);
                IExperiment exp = var != null ? (IExperiment)var.getPossiblePropertyValue(graph, SIMU.Run_iExperiment) : null;
                ITrendSupport iTrendSupport = ts = exp != null ? (ITrendSupport)exp.getService(ITrendSupport.class) : null;
                if (ts != null) {
                    ts.setChartData(graph);
                }
            }
        }

        public boolean isDisposed() {
            return TimeSeriesEditor.this.disposed;
        }
    }

    class ChartDataListener
    extends HintListenerAdapter
    implements Runnable {
        ChartDataListener() {
        }

        public void hintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
            if (key.equals((Object)TimeSeriesEditor.this.chartDataKey) && !TimeSeriesEditor.this.cvsCtx.isDisposed() && TimeSeriesEditor.this.cvsCtx.isAlive()) {
                TimeSeriesEditor.this.cvsCtx.getThreadAccess().asyncExec((Runnable)this);
            }
        }

        @Override
        public void run() {
            if (TimeSeriesEditor.this.cvsCtx.isDisposed() || !TimeSeriesEditor.this.cvsCtx.isAlive()) {
                return;
            }
            ChartData data = (ChartData)Simantics.getProject().getHint((IHintContext.Key)TimeSeriesEditor.this.chartDataKey);
            TimeSeriesEditor.this.setInput(data, TimeSeriesEditor.this.trendNode.getTrendSpec());
        }
    }

    class ChassisListener
    implements IChassisListener {
        ChassisListener() {
        }

        public void chassisClosed(ICanvasChassis sender) {
            CanvasContext ctx = TimeSeriesEditor.this.cvsCtx;
            ThreadUtils.asyncExec((IThreadWorkQueue)ctx.getThreadAccess(), (Runnable)new Runnable((ICanvasContext)ctx){
                private final /* synthetic */ ICanvasContext val$ctx;
                {
                    this.val$ctx = iCanvasContext;
                }

                @Override
                public void run() {
                    if (this.val$ctx != null) {
                        AWTChassis awt = ((ChassisListener)ChassisListener.this).TimeSeriesEditor.this.canvas.getAWTComponent();
                        if (awt != null) {
                            awt.setCanvasContext(null);
                        }
                        this.val$ctx.dispose();
                    }
                }
            });
            TimeSeriesEditor.this.canvas.removeChassisListener((IChassisListener)this);
        }
    }

    class ExperimentStateListener
    implements IExperimentListener {
        ExperimentStateListener() {
        }

        public void stateChanged(ExperimentState state) {
            TrendParticipant t;
            TrendSpec spec = TimeSeriesEditor.this.trendNode.getTrendSpec();
            boolean bl = spec.experimentIsRunning = state == ExperimentState.RUNNING;
            if (spec.experimentIsRunning && spec.viewProfile.trackExperimentTime && (t = TimeSeriesEditor.this.tp) != null) {
                t.setDirty();
            }
        }
    }

    class MilestoneSpecListener
    implements AsyncListener<MilestoneSpec> {
        boolean disposed = false;

        MilestoneSpecListener() {
        }

        public void execute(AsyncReadGraph graph, final MilestoneSpec result) {
            AWTThread.INSTANCE.asyncExec(new Runnable(){

                @Override
                public void run() {
                    ((MilestoneSpecListener)MilestoneSpecListener.this).TimeSeriesEditor.this.trendNode.setMilestones((Bean)result);
                }
            });
        }

        public void exception(AsyncReadGraph graph, Throwable throwable) {
        }

        public boolean isDisposed() {
            return this.disposed;
        }

        public void dispose() {
            this.disposed = true;
        }
    }

    class TrendSpecListener
    implements AsyncListener<TrendSpec> {
        TrendSpecListener() {
        }

        public void exception(AsyncReadGraph graph, Throwable throwable) {
            ErrorLogger.defaultLogError((Throwable)throwable);
            ShowMessage.showError((String)throwable.getClass().getSimpleName(), (String)throwable.getMessage());
        }

        public void execute(AsyncReadGraph graph, final TrendSpec result) {
            if (result == null) {
                LOGGER.info("Chart configuration removed");
            } else {
                LOGGER.info("Chart configuration updated: {}", (Object)result);
            }
            AWTThread.getThreadAccess().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!TimeSeriesEditor.this.disposed) {
                        TimeSeriesEditor.this.setInput(((TrendSpecListener)TrendSpecListener.this).TimeSeriesEditor.this.chartData, result);
                    }
                }
            });
        }

        public boolean isDisposed() {
            return TimeSeriesEditor.this.disposed;
        }
    }

    class ValueTipBoxPositionListener
    extends HintListenerAdapter {
        ValueTipBoxPositionListener() {
        }

        public void hintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
            if (key.equals(TrendParticipant.KEY_VALUE_TIP_BOX_RELATIVE_POS) && newValue != null) {
                Session s = Simantics.getSession();
                ChartResource CHART = (ChartResource)s.getService(ChartResource.class);
                Point2D p = (Point2D)newValue;
                double[] value = new double[]{p.getX(), p.getY()};
                s.asyncRequest((Write)new SetProperty(TimeSeriesEditor.this.getInputResource(), CHART.Chart_valueViewPosition, value, (Binding)Bindings.DOUBLE_ARRAY));
            }
        }
    }
}

