/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.editor;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.simantics.charts.Activator;
import org.simantics.charts.editor.EventData;
import org.simantics.charts.editor.TimeInputValidator;
import org.simantics.utils.format.TimeFormat;

class AddMilestoneDialog
extends Dialog {
    private static final String DIALOG = "AddMilestoneDialog";
    IInputValidator timeValidator = new IInputValidator(){

        public String isValid(String text) {
            if (text.trim().isEmpty()) {
                return null;
            }
            return TimeInputValidator.INSTANCE.isValid(text);
        }
    };
    Label nameLabel;
    Label descLabel;
    Label tagLabel;
    Label timeLabel;
    Label baselineLabel;
    Text nameText;
    Text descText;
    Text tagText;
    Text timeText;
    Button baselineButt;
    ControlDecoration timeDecor;
    EventData data;
    private IDialogSettings dialogBoundsSettings;

    protected AddMilestoneDialog(Shell parentShell, EventData data) {
        super(parentShell);
        this.data = data;
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        this.dialogBoundsSettings = settings.getSection(DIALOG);
        if (this.dialogBoundsSettings == null) {
            this.dialogBoundsSettings = settings.addNewSection(DIALOG);
        }
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return this.dialogBoundsSettings;
    }

    protected int getShellStyle() {
        return 2160;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Add new milestone");
    }

    protected Point getInitialSize() {
        return super.getInitialSize();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayoutFactory.fillDefaults().margins(8, 8).numColumns(4).applyTo(composite);
        GridDataFactory gd1 = GridDataFactory.fillDefaults().span(1, 1);
        GridDataFactory gd2 = GridDataFactory.fillDefaults().minSize(300, -1).indent(10, 0).span(3, 1).grab(true, false);
        this.nameLabel = new Label(composite, 0);
        this.nameLabel.setText("Message:");
        gd1.applyTo((Control)this.nameLabel);
        this.nameText = new Text(composite, 2048);
        this.nameText.setText("My Milestone");
        gd2.applyTo((Control)this.nameText);
        this.tagLabel = new Label(composite, 0);
        this.tagLabel.setText("Tag:");
        gd1.applyTo((Control)this.tagLabel);
        this.tagText = new Text(composite, 2048);
        this.tagText.setText("");
        gd2.applyTo((Control)this.tagText);
        this.descLabel = new Label(composite, 0);
        this.descLabel.setText("Description:");
        gd1.applyTo((Control)this.descLabel);
        this.descText = new Text(composite, 2048);
        gd2.applyTo((Control)this.descText);
        this.timeLabel = new Label(composite, 0);
        this.timeLabel.setText("Time:");
        gd1.applyTo((Control)this.timeLabel);
        this.timeText = new Text(composite, 2048);
        TimeFormat tf = new TimeFormat(this.data.initialTime, 3);
        String time = tf.format((Object)this.data.initialTime);
        this.timeText.setText(time);
        gd2.applyTo((Control)this.timeText);
        this.timeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddMilestoneDialog.this.validateInput();
            }
        });
        this.baselineLabel = new Label(composite, 0);
        this.baselineLabel.setText("Is baseline:");
        gd1.applyTo((Control)this.baselineLabel);
        this.baselineButt = new Button(composite, 32);
        gd2.applyTo((Control)this.baselineButt);
        Image image = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
        this.timeDecor = this.createDecoration((Control)this.timeText, 0x1004000, image);
        this.validateInput();
        return composite;
    }

    protected ControlDecoration createDecoration(Control control, int position, Image image) {
        ControlDecoration d = new ControlDecoration(control, position);
        d.setMarginWidth(2);
        d.setImage(image);
        d.hide();
        return d;
    }

    protected void validateInput() {
        boolean ok = true;
        this.data.time = this.timeText.getText();
        Double parsedTime = TimeInputValidator.INSTANCE.parse(this.data.time);
        if (parsedTime == null) {
            ok = false;
            this.data.parsedTime = 0.0;
        } else {
            this.data.parsedTime = parsedTime;
        }
        this.setDecoration(this.timeDecor, parsedTime == null ? "Invalid time value" : null);
        this.setFinishable(ok);
    }

    private void setDecoration(ControlDecoration decor, String desc) {
        if (decor == null) {
            return;
        }
        if (desc != null) {
            decor.setDescriptionText(desc);
            decor.show();
        } else {
            decor.hide();
        }
    }

    protected void okPressed() {
        this.data.message = this.nameText.getText();
        this.data.tag = this.tagText.getText();
        this.data.description = this.descText.getText();
        this.data.time = this.timeText.getText();
        this.data.isBaseline = this.baselineButt.getSelection();
        this.data.isMilestone = true;
        super.okPressed();
    }

    protected void setFinishable(boolean ok) {
        Button b = this.getButton(0);
        if (b != null) {
            b.setEnabled(ok);
        }
    }
}

