/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.charts.ui;

import java.awt.Color;
import java.util.List;

import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.simantics.charts.ontology.ChartResource;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.trend.impl.JarisPaints;
import org.simantics.ui.contribution.DynamicMenuContribution;
import org.simantics.utils.ui.ISelectionUtils;

public class SetIndexActions extends DynamicMenuContribution {

    public SetIndexActions() {
    }

    public SetIndexActions(String id) {
        super(id);
    }

    protected IContributionItem[] getContributionItems(ReadGraph graph, Object[] selection) throws DatabaseException {
        List<Resource> list = ISelectionUtils.getPossibleKeys(selection, SelectionHints.KEY_MAIN, Resource.class);
        if (list.isEmpty())
            return NONE;
        ChartResource CHART = ChartResource.getInstance(graph);
        boolean allAnalog = true;
        for ( Resource item : list ) {
            Resource rend = graph.getPossibleObject(item, CHART.Chart_Item_Renderer);
            boolean binary = CHART.Renderer_Binary.equals(rend);
            allAnalog &= !binary;
        }

        MenuManager submenu = new MenuManager("Set Index");

        for (int i=0; i<JarisPaints.JarisPaintSequence.length; i++)
        {
            Color color = JarisPaints.JarisPaintSequence[i];
            String label = JarisPaints.JarisPaintName[i];
            SetIndexItem item = new SetIndexItem(color, i+1, label, allAnalog, list);
            submenu.add( item );
        }

        return new IContributionItem[] {submenu};
    }

}
