/*******************************************************************************
 * Copyright (c) 2007, 2024 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *     Semantum Oy - GitLab #1139
 *******************************************************************************/
package org.simantics.charts.editor;

import org.eclipse.jface.action.Action;
import org.simantics.db.Resource;
import org.simantics.trend.impl.TrendNode;

/**
 * @author Tuukka Lehtonen
 */
public class MoveHairlineAction extends Action {

    private final Resource chart;
    private final TrendNode trend;
    private final double time;
    private final Boolean setTrackExperimentTime;

    public MoveHairlineAction(String name, Resource chart, boolean enabled, TrendNode trend, double time) {
        this(name, chart, enabled, trend, time, null);
    }

    public MoveHairlineAction(String name, Resource chart, boolean enabled, TrendNode trend, double time, Boolean setTrackExperimentTime) {
        super(name);
        setEnabled(enabled);
        this.chart = chart;
        this.trend = trend;
        this.time = time;
        this.setTrackExperimentTime = setTrackExperimentTime;
    }

    @Override
    public void run() {
        trend.valueTipTime = Double.isNaN(time) ? null : time;
        trend.repaint();
        if (setTrackExperimentTime != null) {
            TrackExperimentTimeAction.setTracking(chart, setTrackExperimentTime);
        }
    }

}