/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.charts.editor;

import java.awt.event.KeyEvent;

import org.simantics.scenegraph.g2d.events.command.Command;
import org.simantics.scenegraph.g2d.events.command.CommandKeyBinding;
import org.simantics.scenegraph.g2d.events.command.Commands;

/**
 * Describes a key binding of a command
 * 
 * @See {@link Command} Command class
 * @See {@link Commands} Default commands
 * @See KeyToCommand Participant that forwards key presses to commands
 * 
 * @author Toni Kalajainen
 */
public class ChartKeyBindings {
	
    public static final Command LINK_TIME = new Command("org.simantics.charts.linktime");

	public static final CommandKeyBinding[] DEFAULT_BINDINGS = {
		new CommandKeyBinding(LINK_TIME, null, KeyEvent.VK_5)
	};	
	
}
