/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.charts.ui;

import java.awt.Color;
import java.util.List;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.simantics.Simantics;
import org.simantics.charts.Activator;
import org.simantics.charts.query.ChartItemIndexQuery;
import org.simantics.charts.query.SetChartItemIndexRequest;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;

public class SetIndexItem extends ContributionItem implements SelectionListener {

	int index;
	Color color;
	String label;
	Image image;
	LocalResourceManager rm;
	List<Resource> chartItems;
	boolean analogIcon; 
	
	public SetIndexItem(Color color, int index, String label, boolean analogIcon, List<Resource> chartItems)
	{
		super("org.simantics.charts.ui.ColorItem."+index);
		this.index = index;
		this.label = label;
		this.color = color;
		this.chartItems = chartItems;
		this.analogIcon = analogIcon;
	}
	
	@Override
	public void fill(Menu menu, int index) {
		
		MenuItem item = new MenuItem(menu, SWT.CHECK);
//		item.setText( this.index+":"+label );
		item.setText( this.index+"" );
		item.addSelectionListener(this);

		boolean selected = false;
		if (chartItems.size()==1) {
			try {
				Integer selIndex = Simantics.getSession().sync( new ChartItemIndexQuery(chartItems.get(0)) );
				selected = (selIndex!=null) && (this.index == selIndex);
			} catch (DatabaseException e) {
			}
		}
			
		item.setSelection( selected );
		if (rm==null) rm = new LocalResourceManager(JFaceResources.getResources());
				
		ImageDescriptor icon = Activator.getDefault().chartIcons.createIcon(analogIcon, color, selected);
		
		image = (Image) rm.get(icon);
		item.setImage( image );
	}
	
	@Override
	public void dispose() {
		if (rm != null) rm.dispose();
		super.dispose();
	}

	@Override
	public void widgetSelected(SelectionEvent e) {
		for ( Resource chartItem : chartItems) {
			Session s = Simantics.getSession();
			s.markUndoPoint();
			s.async( new SetChartItemIndexRequest(chartItem, index) );
		}
	}

	@Override
	public void widgetDefaultSelected(SelectionEvent e) {
		widgetSelected(e);
	}
	
}