/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.charts.ui;

import java.util.Map;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.State;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.simantics.charts.editor.TimeSeriesEditor;

public class LinkTimeHandler extends AbstractHandler implements IHandler, IElementUpdater {

    public static final String COMMAND_ID = "org.simantics.charts.linktime";
    public static final String STATE_ID = "org.simantics.charts.linktime.state";

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ICommandService service = (ICommandService) PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = service.getCommand( COMMAND_ID );
        State state = command.getState( STATE_ID );
        if (state != null) {
            ChartLinkData oldData = (ChartLinkData) state.getValue();
            if (oldData == null) {
                TimeSeriesEditor editor = getEditor( event );
                ChartLinkData currentData = new ChartLinkData();
                if (editor != null) {
                    editor.getFromEnd(currentData);
                }
                state.setValue( currentData );
            } else {
                state.setValue(null);
            }
        }

        service.refreshElements(COMMAND_ID, null);
        return null;
    }

    /**
     * Get active editor or first one
     * @return
     */
    TimeSeriesEditor getEditor(ExecutionEvent event) {
        IWorkbenchPart ap = HandlerUtil.getActivePart(event);
        if ( ap instanceof TimeSeriesEditor ) return (TimeSeriesEditor) ap;

        IWorkbenchWindow win = HandlerUtil.getActiveWorkbenchWindow(event);
        if (win==null) return null;
        for (IWorkbenchPage page : win.getPages()) {
            for (IEditorReference ref : page.getEditorReferences()) {
                if (ref.getId().equals(TimeSeriesEditor.ID)) {
                    IEditorPart part = ref.getEditor(false);
                    return (TimeSeriesEditor) part;
                }
            }
        }

        return null;
    }

    @Override
    public void updateElement(UIElement element, @SuppressWarnings("rawtypes") Map parameters) {
        ICommandService service = (ICommandService) PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = service.getCommand( COMMAND_ID );
        State state = command.getState( STATE_ID );
        element.setChecked( state != null && state.getValue()!=null );
    }

}
