package org.simantics.charts.ui;

import java.util.Arrays;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.simantics.charts.editor.HideItemsAction;
import org.simantics.charts.ontology.ChartResource;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.ui.contribution.DynamicMenuContribution;
import org.simantics.ui.utils.ResourceAdaptionUtils;

/**
 * @author Tuukka Lehtonen
 */
public class HideItemsContribution extends DynamicMenuContribution {

    public HideItemsContribution() {
    }

    public HideItemsContribution(String id) {
        super(id);
    }

    @Override
    protected Object[] getSelectedObjects() {
        return ResourceAdaptionUtils.toResources(getSelection());
    }

    @Override
    protected boolean preAcceptSelection(Object[] selection) {
        return selection.length > 0;
    }

    @Override
    protected IContributionItem[] getContributionItems(ReadGraph graph, Object[] input) throws DatabaseException {
        Resource[] resources = (Resource[]) input;

        ChartResource CHART = ChartResource.getInstance(graph);

        int hidden = 0;
        int visible = 0;
        for (Resource r : resources) {
            if (!graph.isInstanceOf(r, CHART.Chart_Item))
                return NONE;
            Boolean isHidden = graph.getPossibleRelatedValue(r, CHART.Chart_Item_hidden, Bindings.BOOLEAN);
            if (Boolean.TRUE.equals(isHidden))
                ++hidden;
            else
                ++visible;
        }

        IAction hide = visible > 0 ? new HideItemsAction("Hide Items", true, Arrays.asList(resources)) : null;
        IAction show = hidden > 0 ? new HideItemsAction("Unhide Items", false, Arrays.asList(resources)) : null;
        if (hidden > 0 && visible > 0)
            return toContributionItems(hide, show);
        if (hidden > 0)
            return toContributionItems(show);
        return toContributionItems(hide);
    }

}
