/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.charts.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

import org.simantics.charts.query.AddChartItem;
import org.simantics.charts.query.ChartItemDescriptor;
import org.simantics.databoard.util.ObjectUtils;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.PasteHandlerAdapter;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.layer0.util.ClipboardUtils;
import org.simantics.db.layer0.util.PasteEventHandler;
import org.simantics.db.layer0.util.SimanticsClipboard;
import org.simantics.db.layer0.util.SimanticsClipboard.Representation;
import org.simantics.db.layer0.util.SimanticsKeys;
import org.simantics.modeling.ModelingResources;

/**
 * Paste handler of Paste Resource
 * 
 * @author Tuukka Lehtonen
 */
public class ChartPasteHandler extends PasteHandlerAdapter {

    private Resource chart;

    public ChartPasteHandler(Resource chart) {
        this.chart = chart;
    }

    @Override
    public Collection<Resource> pasteFromClipboard(WriteGraph graph, SimanticsClipboard clipboard, PasteEventHandler handler) throws DatabaseException {
        final List<Resource> resources = new ArrayList<Resource>();
        for (Set<Representation> object : clipboard.getContents()) {
            Collection<Resource> rs = ClipboardUtils.accept(object, SimanticsKeys.KEY_COPY_RESOURCES);
            if (rs != null)
                resources.addAll(rs);
        }

        if (resources.isEmpty())
            return Collections.emptyList();

        return graph.syncRequest(new WriteResultRequest<Collection<Resource>>() {
            @Override
            public Collection<Resource> perform(WriteGraph graph) throws DatabaseException {
                ModelingResources MOD = ModelingResources.getInstance(graph);
                Resource expectedModel = graph.syncRequest( new PossibleModel(chart) );
                List<ChartItemDescriptor> refs = new ArrayList<ChartItemDescriptor>();
                for (Resource r : resources) {
                    if (graph.isInstanceOf(r, MOD.Subscription_Item)) {
                        Resource model = graph.syncRequest(new PossibleModel(r));
                        if (ObjectUtils.objectEquals(expectedModel, model))
                            refs.add( AddChartItem.createDescriptor(graph, r) );
                    }
                }
                if (!refs.isEmpty())
                    return AddChartItem.addAndMoveChartItems(chart, refs, Collections.<Resource>emptySet()).perform(graph);
                else
                	return Collections.emptyList();
            }
        });
    }

    @SuppressWarnings("rawtypes")
    @Override
    public Object getAdapter(Class adapter) {
        if (Resource.class == adapter)
            return chart;
        return null;
    }

}
