/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.charts.ui;

import java.awt.Color;
import java.util.Map;

import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.browsing.ui.model.images.ImageRule;
import org.simantics.charts.ontology.ChartResource;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.trend.impl.JarisPaints;
import org.simantics.utils.datastructures.ArrayMap;

public enum ChartItemImageRule implements ImageRule {

    INSTANCE;
    public static ChartItemImageRule get() { return INSTANCE; }

    public static final String COLUMN_KEY         = "single";
    public static final String[] COLUMN_KEYS      = { COLUMN_KEY };

    ChartItemIcon chartIcons = new ChartItemIcon();

    @Override
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class);
    }

    @Override
    public Map<String, ImageDescriptor> getImage(ReadGraph graph, Object content) throws DatabaseException {
        Resource item = (Resource) content;
        ChartResource CHART = ChartResource.getInstance(graph);
        G2DResource G2D = G2DResource.getInstance(graph);

        Color color = null;
        float[] customColor = graph.getPossibleRelatedValue(item, G2D.HasColor, Bindings.FLOAT_ARRAY);
        if (customColor != null && customColor.length >= 3)
            color = new Color(customColor[0], customColor[1], customColor[2]);
        if (color == null) {
            Integer index = graph.getPossibleRelatedValue(item, CHART.Chart_Item_Index);
            if ( index == null ) index = 1;
            color = JarisPaints.getColor( index );
        }

        Resource rend = graph.getPossibleObject(item, CHART.Chart_Item_Renderer);
        boolean binary = CHART.Renderer_Binary.equals(rend); 

        ImageDescriptor icon = chartIcons.createIcon(!binary, color, false);

        return ArrayMap.make(COLUMN_KEYS, new ImageDescriptor[] { icon });
    }

}
