/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.charts.ui;

import java.awt.Color;

import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.Bundle;
import org.simantics.charts.Activator;
import org.simantics.utils.ui.gfx.CompositionImageDescriptor;
import org.simantics.utils.ui.gfx.RGBAdjustmentImageDescriptor;

public class ChartItemIcon {

	public ImageDescriptor tagEmpty, tagLabel, binaryEmpty, binaryLabel;
	
	public ChartItemIcon() {
		Bundle bundle = Activator.getDefault().getBundle();
        tagEmpty = ImageDescriptor.createFromURL(bundle.getResource("icons/tag_empty.png"));
        tagLabel = ImageDescriptor.createFromURL(bundle.getResource("icons/tag_label.png"));
        binaryEmpty = ImageDescriptor.createFromURL(bundle.getResource("icons/binary_empty.png"));
        binaryLabel = ImageDescriptor.createFromURL(bundle.getResource("icons/binary_label.png"));		
	}
	
	public ImageDescriptor createIcon( boolean analog, Color color, boolean selected )
	{
        ImageDescriptor _base = analog ? tagEmpty : binaryEmpty;
        ImageDescriptor _label = analog ? tagLabel : binaryLabel;
        
        if ( selected ) _base = new RGBAdjustmentImageDescriptor(_base, 200, 200, 300);
        
		ImageDescriptor label = new RGBAdjustmentImageDescriptor(_label, color.getRed(), color.getGreen(), color.getBlue());
		ImageDescriptor icon = CompositionImageDescriptor.compose(_base, label);
		
		return icon;
	}
	
}
