/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.charts.ui;

import java.util.List;

import org.simantics.Simantics;
import org.simantics.charts.ontology.ChartResource;
import org.simantics.databoard.util.ObjectUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.layer0.adapter.DropActionFactory;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.modeling.ModelingResources;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.ISelectionUtils;

/**
 * @author Tuukka Lehtonen
 */
public class ChartItemDropActionFactory implements DropActionFactory {

    @Override
    public Runnable create(ReadGraph g, Object target, Object source, int operation) throws DatabaseException {
        //System.out.println("DROP: " + source + " -> " + target);

        final Resource chartItem = ISelectionUtils.getSinglePossibleKey(target, SelectionHints.KEY_MAIN, Resource.class);
        if (chartItem == null)
            return null;
        Resource targetModel = g.syncRequest(new PossibleModel(chartItem));

        List<Resource> srcs = ISelectionUtils.getPossibleKeys(source, SelectionHints.KEY_MAIN, Resource.class);
        ModelingResources MOD = ModelingResources.getInstance(g);

        Resource subscriptionItem = null;

        for (Resource res : srcs) {
        	if (g.isInstanceOf(res, MOD.Subscription_Item)) {
        		// Too much stuff dropped in one go.
        		if (subscriptionItem != null)
        			return null;

        		Resource model = g.syncRequest(new PossibleModel(res));
        		if (ObjectUtils.objectEquals(targetModel, model)) {
        			subscriptionItem = res;
        		}
            }
        }
        if (subscriptionItem != null)
        	return setSubscriptionItem(chartItem, subscriptionItem);

        return null;
    }

    private Runnable setSubscriptionItem(final Resource chartItem, final Resource subscriptionItem) {
        return new Runnable() {
            @Override
            public void run() {
                Simantics.getSession().asyncRequest(new WriteRequest() {
                    @Override
                    public void perform(WriteGraph graph) throws DatabaseException {
                    	ChartResource CHART = ChartResource.getInstance(graph);
                    	graph.deny(chartItem, CHART.Chart_Item_HasSubscriptionItem);
                    	graph.claim(chartItem, CHART.Chart_Item_HasSubscriptionItem, subscriptionItem);
                    }
                }, e -> {
                    if (e != null)
                        ErrorLogger.defaultLogError(e);
                });
            }
        };
    }

}
