/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.charts.query;

import org.simantics.charts.ontology.ChartResource;
import org.simantics.databoard.Bindings;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;

/**
 * Sets item index value
 * @author toni.kalajainen
 */
public class SetChartItemIndexRequest extends WriteRequest {

	Resource chartItem;
	int index;
	
	public SetChartItemIndexRequest(Resource chartItem, int index)
	{
		this.chartItem = chartItem;
		this.index = index;
	}
	
	@Override
	public void perform(WriteGraph graph) throws DatabaseException {
		ChartResource CHART = ChartResource.getInstance(graph);
		graph.claimLiteral(chartItem, CHART.Chart_Item_Index, index, Bindings.INTEGER);
	}

}
