/*******************************************************************************
 * Copyright (c) 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.charts.editor;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.charts.Activator;
import org.simantics.trend.impl.TrendNode;
import org.simantics.trend.util.PrintUtil;
import org.simantics.utils.ui.dialogs.ShowMessage;

/**
 * @author Tuukka Lehtonen
 */
public class ExportToPdfHandler extends AbstractHandler {

    FileDialog fd;
    Display display;

    public ExportToPdfHandler() 
    {
        super();
        display = PlatformUI.createDisplay();
        Shell shell = display.getActiveShell();
        fd = new FileDialog( shell, SWT.SAVE );
        fd.setText("Select PDF File");
        fd.setFilterExtensions(new String[] {"*.pdf"});
        fd.setFilterNames(new String[] {"PDF Documents"});
    }

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        final TimeSeriesEditor editor = (TimeSeriesEditor) HandlerUtil.getActiveEditor(event);
        final TrendNode trend = editor.trendNode;

        // TODO: query file name from user, preferably create a wizard.
        String name = trend.getTrendSpec().name;
        fd.setText("Export "+name+" to PDF");

        String filename = fd.open();
        if (filename == null) return null;
        final File f = new File( filename );

        IRunnableWithProgress r = new IRunnableWithProgress() {
            @Override
            public void run(IProgressMonitor monitor)
                    throws InvocationTargetException, InterruptedException {
                try {
                    // Ensure all views are built.
                    monitor.setTaskName("Exporting");
                    PrintUtil pu = new PrintUtil();
                    pu.addTrendPage(trend);
                    try {
                        //File f = File.createTempFile("Trend", ".pdf");
                        pu.printPdf(f);
                        System.out.println("Printed Trend to "+f);
                    } catch (IOException e1) {
                    	throw new InvocationTargetException( e1 );
                    } 
                    monitor.setTaskName("Done");

                    // Put exported file name into clipboard.
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    Clipboard clipboard = toolkit.getSystemClipboard();
                    StringSelection strSel = new StringSelection(f.getAbsolutePath());
                    clipboard.setContents(strSel, null);
                    
                } finally {
                    monitor.done();
                }
            }
        };

        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile( r );
        } catch (InvocationTargetException e) {
        	ShowMessage.showError(e.getCause().getClass().getName(), e.getCause().getMessage());        	
        	Status s = new Status(IStatus.ERROR, Activator.PLUGIN_ID, "PDF Export failed: "+e.getCause().getMessage(), e.getCause());
        	Activator.getDefault().getLog().log(s);
        } catch (InterruptedException e) {
        	Status s = new Status(IStatus.ERROR, Activator.PLUGIN_ID, "PDF Export failed: "+e.getCause().getMessage(), e.getCause());
        	Activator.getDefault().getLog().log(s);
        }

        return null;
    }
    
    @Override
    public void dispose() {
    	if (display!=null) {
//    		display.dispose();
    		display = null;
    	}
    	super.dispose();    	
    }

}
