/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.charts.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.simantics.Simantics;
import org.simantics.charts.Activator;
import org.simantics.charts.query.AddChartItem;
import org.simantics.charts.query.ChartItemDescriptor;
import org.simantics.databoard.util.ObjectUtils;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.layer0.util.ClipboardUtils;
import org.simantics.db.layer0.util.SimanticsClipboard.Representation;
import org.simantics.db.layer0.util.SimanticsKeys;
import org.simantics.g2d.canvas.ICanvasParticipant;
import org.simantics.g2d.canvas.impl.AbstractCanvasParticipant;
import org.simantics.modeling.ModelingResources;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection.EventHandler;
import org.simantics.scenegraph.g2d.events.command.CommandEvent;
import org.simantics.scenegraph.g2d.events.command.Commands;

/**
 * Handles paste to TimeSeriesEditor
 * 
 * @author toni.kalajainen
 */
public class ChartPasteHandler2 extends AbstractCanvasParticipant implements ICanvasParticipant {

    private Resource chart;

    public ChartPasteHandler2(Resource chart) {
        this.chart = chart;
    }

    @EventHandler(priority = 0)
    public boolean handleCommandEvent(CommandEvent e) {

        if (e.command == Commands.PASTE) {

            final List<Resource> resources = new ArrayList<Resource>();
            for (Set<Representation> object : Simantics.getClipboard().getContents()) {
                Collection<Resource> rs;
                try {
                    rs = ClipboardUtils.accept(object, SimanticsKeys.KEY_COPY_RESOURCES);
                    if (rs != null)
                        resources.addAll(rs);
                } catch (DatabaseException ex) {
                    Activator.getDefault().getLog().log(new Status(IStatus.ERROR, Activator.PLUGIN_ID,
                            "Failed to retrieve clipboard contents.", ex));
                }
            }

            if (resources.isEmpty())
                return true;

            Simantics.getSession().asyncRequest(new WriteRequest() {
                @Override
                public void perform(WriteGraph graph) throws DatabaseException {
                    Resource expectedModel = graph.syncRequest(new PossibleModel(chart));
                    if (expectedModel == null || chart == null)
                        return;
                    ModelingResources MOD = ModelingResources.getInstance(graph);
                    List<ChartItemDescriptor> refs = new ArrayList<ChartItemDescriptor>();
                    for (Resource r : resources) {
                        if (graph.isInstanceOf(r, MOD.Subscription_Item)) {
                            Resource model = graph.syncRequest(new PossibleModel(r));
                            if (ObjectUtils.objectEquals(expectedModel, model))
                                refs.add(AddChartItem.createDescriptor(graph, r));
                        }
                    }

                    if (!refs.isEmpty()) {
                        AddChartItem.addAndMoveChartItems(chart, refs, Collections.<Resource> emptySet())
                                .perform(graph);
                    }
                }
            });
            return true;
        }

        return false;

    }

}
