/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.model.actions;

import org.simantics.browsing.ui.model.actions.IActionCategory;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.viewpoint.ontology.ViewpointResource;

public class ActionCategory
implements IActionCategory {
    Resource resource;
    String label;
    double priority;
    boolean isSubmenu;

    public ActionCategory(Resource resource, String label, double priority, boolean isSubmenu) {
        this.resource = resource;
        this.label = label;
        this.priority = priority;
        this.isSubmenu = isSubmenu;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public double getPriority() {
        return this.priority;
    }

    @Override
    public boolean isSubmenu() {
        return this.isSubmenu;
    }

    public static ActionCategory create(ReadGraph g, Resource r) throws DatabaseException {
        ViewpointResource vr = ViewpointResource.getInstance((ReadGraph)g);
        String label = NameUtils.getSafeLabel((ReadGraph)g, (Resource)r);
        Resource priorityResource = g.getPossibleObject(r, vr.ActionCategory_HasPriority);
        double priority = priorityResource == null ? 0.0 : (Double)g.getValue(priorityResource, (Binding)Bindings.DOUBLE);
        Resource isSubmenuResource = g.getPossibleObject(r, vr.ActionCategory_IsSubmenu);
        boolean isSubmenu = isSubmenuResource == null ? false : (Boolean)g.getValue(isSubmenuResource, (Binding)Bindings.BOOLEAN);
        return new ActionCategory(r, label, priority, isSubmenu);
    }

    public int hashCode() {
        return this.resource.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != ActionCategory.class) {
            return false;
        }
        return this.resource.equals(((ActionCategory)obj).resource);
    }
}

