/*
 * Decompiled with CFR 0.152.
 */
package winterwell.markdown.pagemodel;

import java.util.List;
import winterwell.utils.StrUtils;

public class MarkdownFormatter {
    private MarkdownFormatter() {
    }

    public static String format(List<String> lines, int lineWidth) {
        if (lines == null) {
            return null;
        }
        String lineEndings = lines.get(0).endsWith("\r\n") ? "\r\n" : (lines.get(0).endsWith("\r") ? "\r" : StrUtils.LINEEND);
        StringBuilder buf = new StringBuilder();
        for (String line : lines) {
            buf.append(line);
            buf.append(' ');
        }
        return MarkdownFormatter.format(buf.toString(), lineWidth, lineEndings);
    }

    public static String format(String text, int lineWidth) {
        return MarkdownFormatter.format(text, lineWidth, StrUtils.LINEEND);
    }

    public static String format(String text, int lineWidth, String lineEnding) {
        return new String(MarkdownFormatter.format(text.toCharArray(), lineWidth, lineEnding));
    }

    /*
     * Unable to fully structure code
     */
    static char[] format(char[] text, int lineWidth, String lineEnding) {
        word = new StringBuilder();
        indent = new StringBuilder();
        buffer = new StringBuilder(text.length + 10);
        state = StatePosition.BEGIN_FIRST_LINE;
        lineLength = 0;
        endWordwrap1 = '\u0000';
        endWordwrap2 = '\u0000';
        i = 0;
        while (i <= text.length) {
            block46: {
                block47: {
                    block45: {
                        c = i < text.length ? text[i] : '\u0000';
                        nextChar = i + 1 < text.length ? text[i + 1] : '\u0000';
                        if (endWordwrap1 == '\u0000') break block45;
                        if (endWordwrap2 == '\u0000' && c == endWordwrap1 || c == endWordwrap1 && nextChar == endWordwrap2) {
                            endWordwrap1 = '\u0000';
                        }
                        buffer.append(c);
                        ++lineLength;
                        if (endWordwrap1 == '\u0000' && endWordwrap2 != '\u0000') {
                            buffer.append(nextChar);
                            ++lineLength;
                            ++i;
                        }
                        break block46;
                    }
                    if (c == '[') {
                        endWordwrap1 = ']';
                    } else if (c == '*' && nextChar == '*') {
                        endWordwrap1 = '*';
                        endWordwrap2 = '*';
                    } else if (c == '*' && state == StatePosition.MIDDLE_OF_LINE) {
                        endWordwrap1 = '*';
                    } else if (c == '`') {
                        endWordwrap1 = '`';
                    } else if (c == '(' && nextChar == '(') {
                        endWordwrap1 = ')';
                        endWordwrap2 = ')';
                    } else if (c == '!' && nextChar == '[') {
                        endWordwrap1 = ')';
                    }
                    if (endWordwrap1 == '\u0000') break block47;
                    if (word.length() > 0) {
                        lineLength = MarkdownFormatter.addWordToBuffer(lineWidth, lineEnding, word, indent, buffer, lineLength);
                    } else if (buffer.length() > 0 && buffer.charAt(buffer.length() - 1) != ']') {
                        buffer.append(' ');
                    }
                    buffer.append(c);
                    ++lineLength;
                    break block46;
                }
                if (state != StatePosition.BEGIN_FIRST_LINE) ** GOTO lbl83
                if (c == '\n' || c == '\r') {
                    buffer.append(c);
                    lineLength = 0;
                } else {
                    if (Character.isWhitespace(c)) {
                        indent.append(c);
                    } else if ((c == '*' || c == '-' || c == '.') && Character.isWhitespace(nextChar)) {
                        indent.append(' ');
                    } else if (Character.isDigit(c) && nextChar == '.' && Character.isWhitespace(text[i + 2])) {
                        indent.append(' ');
                    } else if (c == '>') {
                        indent.append('>');
                    } else {
                        state = StatePosition.MIDDLE_OF_LINE;
                    }
                    if (state == StatePosition.BEGIN_FIRST_LINE) {
                        buffer.append(c);
                        ++lineLength;
                    }
lbl83:
                    // 4 sources

                    if (state != StatePosition.BEGIN_FIRST_LINE) {
                        if (state != StatePosition.MIDDLE_OF_LINE) {
                            if (Character.isWhitespace(c) || c == '>' || c == '.') {
                                word.append(c);
                            } else if ((c == '*' || c == '-') && Character.isWhitespace(nextChar) || Character.isDigit(c) && nextChar == '.' && Character.isWhitespace(text[i + 2])) {
                                word.append(c);
                                state = StatePosition.BEGIN_NEW_LINE;
                            } else {
                                if (state == StatePosition.BEGIN_NEW_LINE) {
                                    buffer.append((CharSequence)word);
                                    lineLength = word.substring(word.indexOf("\n") + 1).length();
                                }
                                word.setLength(0);
                                state = StatePosition.MIDDLE_OF_LINE;
                            }
                        }
                        if (state == StatePosition.MIDDLE_OF_LINE) {
                            if (Character.isWhitespace(c) || c == '\u0000') {
                                if (word.length() > 0) {
                                    lineLength = MarkdownFormatter.addWordToBuffer(lineWidth, lineEnding, word, indent, buffer, lineLength);
                                } else if (c == ' ' && (nextChar == '\r' || nextChar == '\n') && state != StatePosition.BEGIN_OTHER_LINE) {
                                    buffer.append("  ");
                                    buffer.append(lineEnding);
                                    lineLength = 0;
                                }
                                if (c == '\r' || c == '\n') {
                                    state = StatePosition.BEGIN_OTHER_LINE;
                                    word.append(c);
                                }
                                if (c == '\n' && nextChar == '\n' || c == '\r' && nextChar == '\n' && text[i + 2] == '\r' && text[i + 3] == '\n') {
                                    state = StatePosition.BEGIN_FIRST_LINE;
                                    word.setLength(0);
                                    indent.setLength(0);
                                    lineLength = 0;
                                    if (c == '\r') {
                                        ++i;
                                        buffer.append("\r\n");
                                    } else {
                                        buffer.append(c);
                                    }
                                }
                            } else {
                                word.append(c);
                                state = StatePosition.MIDDLE_OF_LINE;
                            }
                        }
                    }
                }
            }
            ++i;
        }
        return buffer.toString().toCharArray();
    }

    private static int addWordToBuffer(int lineWidth, String lineEnding, StringBuilder word, StringBuilder indent, StringBuilder buffer, int lineLength) {
        if (word.length() + lineLength + 1 > lineWidth) {
            buffer.append(lineEnding);
            buffer.append((CharSequence)indent);
            buffer.append((CharSequence)word);
            lineLength = indent.length() + word.length();
        } else {
            if (lineLength > indent.length()) {
                buffer.append(' ');
            }
            buffer.append((CharSequence)word);
            lineLength += word.length() + 1;
        }
        word.setLength(0);
        return lineLength;
    }

    private static enum StatePosition {
        BEGIN_FIRST_LINE,
        BEGIN_OTHER_LINE,
        BEGIN_NEW_LINE,
        MIDDLE_OF_LINE;

    }
}

