/*
 * Decompiled with CFR 0.152.
 */
package winterwell.markdown;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import winterwell.utils.Mutable;
import winterwell.utils.containers.Pair;

public final class StringMethods {
    public static final String LINEEND = System.getProperty("line.separator");

    public static String stripTags(String page) {
        StringBuilder stripped = new StringBuilder(page.length());
        boolean inTag = false;
        boolean inComment = false;
        boolean inScript = false;
        int i = 0;
        while (i < page.length()) {
            char c = page.charAt(i);
            if (inTag) {
                if (c == '>') {
                    inTag = false;
                }
            } else if (inComment) {
                if (c == '>' && page.charAt(i - 1) == '-' && page.charAt(i - 1) == '-') {
                    inComment = false;
                }
            } else if (inScript) {
                if (c == '>' && page.substring(i - 7, i).equals("/script")) {
                    inScript = false;
                }
            } else if (c == '<' && !Character.isWhitespace(page.charAt(i + 1))) {
                if (page.charAt(i + 1) == '!' && page.charAt(i + 2) == '-' && page.charAt(i + 3) == '-') {
                    inComment = true;
                } else if (i + 8 < page.length() && page.substring(i + 1, i + 7).equals("script")) {
                    inScript = true;
                    i += 7;
                } else {
                    inTag = true;
                }
            } else {
                stripped.append(c);
            }
            ++i;
        }
        return stripped.toString();
    }

    public static final String capitalise(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase();
    }

    public static final String convertLineBreaks(String text) {
        return StringMethods.convertLineBreaks(text, LINEEND);
    }

    public static final String convertLineBreaks(String text, String br) {
        text = text.replaceAll("\r\n", br);
        text = text.replaceAll("\r", br);
        text = text.replaceAll("\n", br);
        return text;
    }

    public static int countCharsInString(String string, char character) {
        int count = 0;
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == character) {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    public static Pair<Integer> findEnclosingRegion(String text, int offset, char startMarker, char endMarker) {
        int end = StringMethods.findEnclosingRegion2(text, offset, endMarker, 1);
        if (end == -1) {
            return null;
        }
        ++end;
        int start = StringMethods.findEnclosingRegion2(text, offset, startMarker, -1);
        if (start == -1) {
            return null;
        }
        assert (text.substring(start, end).charAt(0) == startMarker);
        assert (text.substring(start, end).endsWith("" + endMarker));
        return new Pair((Object)start, (Object)end);
    }

    private static int findEnclosingRegion2(String text, int offset, char endMarker, int direction) {
        while (offset > -1 && offset < text.length()) {
            char c = text.charAt(offset);
            if (c == endMarker) {
                return offset;
            }
            offset += direction;
        }
        return -1;
    }

    public static String findEnclosingText(String text, int offset, char startMarker, char endMarker) {
        Pair<Integer> region = StringMethods.findEnclosingRegion(text, offset, startMarker, endMarker);
        if (region == null) {
            return null;
        }
        String s = text.substring((Integer)region.first, (Integer)region.second);
        return s;
    }

    public static String format(String text, int lineWidth, int tabWidth, String respectLeadingCharacters) {
        text = StringMethods.convertLineBreaks(text, "\n");
        List<String> paras = StringMethods.format2_splitParagraphs(text, respectLeadingCharacters);
        StringBuilder sb = new StringBuilder(text.length() + 10);
        for (String p : paras) {
            String fp = StringMethods.format3_oneParagraph(p, lineWidth, tabWidth, respectLeadingCharacters);
            sb.append(fp);
            sb.append("\n\n");
        }
        sb.delete(sb.length() - 2, sb.length());
        text = StringMethods.convertLineBreaks(sb.toString());
        return text;
    }

    private static List<String> format2_splitParagraphs(String text, String respectLeadingCharacters) {
        ArrayList<String> paras = new ArrayList<String>();
        Mutable.Int index = new Mutable.Int(0);
        while (index.value < text.length()) {
            boolean inSpace = false;
            int start = index.value;
            while (index.value < text.length()) {
                char c = text.charAt(index.value);
                ++index.value;
                if (!Character.isWhitespace(c)) {
                    inSpace = false;
                    continue;
                }
                if (c != '\r' && c != '\n') continue;
                if (inSpace) break;
                inSpace = true;
            }
            String p = text.substring(start, index.value);
            paras.add(p);
        }
        return paras;
    }

    private static String format3_oneParagraph(String p, int lineWidth, int tabWidth, String respectLeadingCharacters) {
        StringBuilder sb = new StringBuilder(p.length() + 10);
        String leadingChars = StringMethods.format4_getLeadingChars(p, respectLeadingCharacters);
        sb.append(leadingChars);
        int lineLength = leadingChars.length();
        int index = leadingChars.length();
        while (index < p.length()) {
            StringBuilder word = new StringBuilder();
            char c = p.charAt(index);
            ++index;
            while (!Character.isWhitespace(c)) {
                word.append(c);
                if (index == p.length()) break;
                c = p.charAt(index);
                ++index;
            }
            if (lineLength + word.length() > lineWidth && lineLength != 0) {
                StringMethods.trimEnd(sb);
                sb.append('\n');
                sb.append(leadingChars);
                lineLength = leadingChars.length();
            }
            sb.append((CharSequence)word);
            if (index == p.length() || (lineLength += word.length()) >= lineWidth) continue;
            if (c == '\n') {
                c = ' ';
            }
            sb.append(c);
            lineLength += c == '\t' ? tabWidth : 1;
        }
        StringMethods.trimEnd(sb);
        return sb.toString();
    }

    private static String format4_getLeadingChars(String text, String respectLeadingCharacters) {
        if (respectLeadingCharacters == null) {
            return "";
        }
        assert (respectLeadingCharacters.indexOf(10) == -1);
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (respectLeadingCharacters.indexOf(c) == -1) {
                return text.substring(0, i);
            }
            ++i;
        }
        return text;
    }

    public static final String lineEnd(String line) {
        if (((String)line).endsWith("\n")) {
            line = ((String)line).substring(0, ((String)line).length() - 1);
        }
        if (((String)line).endsWith("\r\n")) {
            line = ((String)line).substring(0, ((String)line).length() - 2);
        }
        if (((String)line).endsWith("\r")) {
            line = ((String)line).substring(0, ((String)line).length() - 1);
        }
        if (!((String)line).endsWith(LINEEND)) {
            line = (String)line + LINEEND;
        }
        return line;
    }

    public static final void lineEnd(StringBuilder line) {
        if (line.length() == 0) {
            line.append(LINEEND);
            return;
        }
        char last = line.charAt(line.length() - 1);
        if (last == '\n') {
            if (line.length() > 1 && line.charAt(line.length() - 2) == '\r') {
                line.replace(line.length() - 2, line.length(), LINEEND);
                return;
            }
            line.replace(line.length() - 1, line.length(), LINEEND);
            return;
        }
        if (last == '\r') {
            line.replace(line.length() - 1, line.length(), LINEEND);
            return;
        }
        line.append(LINEEND);
    }

    public static String md5Hash(String string) {
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        md5.update(string.getBytes());
        BigInteger hash = new BigInteger(1, md5.digest());
        return hash.toString(16);
    }

    public static String removeTags(String s) {
        StringBuffer sb = new StringBuffer();
        boolean inTag = false;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '<') {
                inTag = true;
            }
            if (!inTag) {
                sb.append(c);
            }
            if (c == '>') {
                inTag = false;
            }
            ++i;
        }
        return sb.toString();
    }

    public static String repeat(Character c, int i) {
        StringBuilder dashes = new StringBuilder(i);
        int j = 0;
        while (j < i) {
            dashes.append(c);
            ++j;
        }
        return dashes.toString();
    }

    public static List<String> splitLines(String text) {
        ArrayList<String> lines = new ArrayList<String>();
        int start = 0;
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (c == '\r' || c == '\n') {
                if (i + 1 < text.length()) {
                    char c2 = text.charAt(i + 1);
                    if (c == '\r' && c2 == '\n') {
                        ++i;
                    }
                }
                String line = text.substring(start, i + 1);
                lines.add(line);
                start = i + 1;
            }
            ++i;
        }
        if (start != text.length()) {
            String line = text.substring(start);
            lines.add(line);
        }
        return lines;
    }

    private static void trimEnd(StringBuilder sb) {
        int i;
        while ((i = sb.length() - 1) != -1) {
            char c = sb.charAt(i);
            if (!Character.isWhitespace(c)) {
                return;
            }
            sb.deleteCharAt(i);
        }
        return;
    }

    public static final boolean whitespace(String s) {
        if (s == null) {
            return true;
        }
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (!Character.isWhitespace(c)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int wordCount(String text) {
        String[] bits = text.split("\\W+");
        int wc = 0;
        String[] stringArray = bits;
        int n = bits.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (!StringMethods.whitespace(string)) {
                ++wc;
            }
            ++n2;
        }
        return wc;
    }
}

