/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.workbench.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.ide.ChooseWorkspaceData;
import org.eclipse.ui.internal.ide.ChooseWorkspaceDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.simantics.Simantics;
import org.simantics.application.arguments.ApplicationUtils;
import org.simantics.application.arguments.Arguments;
import org.simantics.application.arguments.IArgumentFactory;
import org.simantics.application.arguments.IArguments;
import org.simantics.application.arguments.SimanticsArguments;
import org.simantics.db.layer0.internal.SimanticsInternal;
import org.simantics.db.management.ISessionContextProvider;
import org.simantics.db.management.ISessionContextProviderSource;
import org.simantics.db.management.SessionContextProvider;
import org.simantics.db.management.SingleSessionContextProviderSource;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.ui.BundleUtils;
import org.simantics.workbench.internal.DelayedEventsProcessor;
import org.simantics.workbench.internal.Messages;
import org.simantics.workbench.internal.SimanticsWorkbenchAdvisor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimanticsWorkbenchApplication
implements IApplication,
IExecutableExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimanticsWorkbenchApplication.class);
    public static final String METADATA_FOLDER = ".metadata";
    private static final String VERSION_FILENAME = "version.ini";
    private static final String WORKSPACE_VERSION_KEY = "org.eclipse.core.runtime";
    private static final String WORKSPACE_VERSION_VALUE = "1";
    private static final String PROP_EXIT_CODE = "eclipse.exitcode";
    private static final String PROP_SHUTDOWN_GRACE_PERIOD = "simantics.shutdownGracePeriod";
    private static final long DEFAULT_SHUTDOWN_GRACE_PERIOD = 5000L;
    private static final Integer EXIT_RELAUNCH = new Integer(24);
    private static final Integer EXIT_WORKSPACE_LOCKED = new Integer(15);

    public WorkbenchAdvisor createWorkbenchAdvisor(IArguments args, DelayedEventsProcessor processor) {
        return new SimanticsWorkbenchAdvisor(args, processor);
    }

    public Object start(IApplicationContext appContext) throws Exception {
        ApplicationUtils.loadSystemProperties((URL)BundleUtils.find((String)"org.simantics.workbench", (String)"system.properties"));
        IArguments args = this.parseArguments((String[])appContext.getArguments().get("application.args"));
        Display display = this.createDisplay();
        DelayedEventsProcessor processor = new DelayedEventsProcessor(display);
        try {
            long shutdownGracePeriod;
            Object instanceLocationCheck;
            Object argCheck = this.verifyArguments(args);
            if (argCheck != null) {
                Object object = argCheck;
                return object;
            }
            Shell shell = WorkbenchPlugin.getSplashShell((Display)display);
            if (shell != null) {
                shell.setText(ChooseWorkspaceDialog.getWindowTitle());
                shell.setImages(Dialog.getDefaultImages());
            }
            if ((instanceLocationCheck = this.checkInstanceLocation(shell, appContext.getArguments(), args)) != null) {
                WorkbenchPlugin.unsetSplashShell((Display)display);
                Platform.endSplash();
                Object object = instanceLocationCheck;
                return object;
            }
            SessionContextProvider provider = new SessionContextProvider(null);
            SingleSessionContextProviderSource contextProviderSource = new SingleSessionContextProviderSource((ISessionContextProvider)provider);
            SimanticsUI.setSessionContextProviderSource((ISessionContextProviderSource)contextProviderSource);
            SimanticsInternal.setSessionContextProviderSource((ISessionContextProviderSource)contextProviderSource);
            Simantics.setSessionContextProviderSource((ISessionContextProviderSource)contextProviderSource);
            int returnCode = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)this.createWorkbenchAdvisor(args, processor));
            Long shutdownGracePeriodPropValue = Long.getLong(PROP_SHUTDOWN_GRACE_PERIOD);
            long l = shutdownGracePeriod = shutdownGracePeriodPropValue == null ? 5000L : shutdownGracePeriodPropValue;
            if (returnCode != 1) {
                this.delayedShutdown(EXIT_OK, shutdownGracePeriod);
                Integer n = EXIT_OK;
                return n;
            }
            int exitCode = EXIT_RELAUNCH.equals(Integer.getInteger(PROP_EXIT_CODE)) ? EXIT_RELAUNCH : EXIT_RESTART;
            this.delayedShutdown(exitCode, shutdownGracePeriod);
            Integer n = exitCode;
            return n;
        }
        finally {
            Location instanceLoc;
            if (display != null) {
                display.dispose();
            }
            if ((instanceLoc = Platform.getInstanceLocation()) != null) {
                instanceLoc.release();
            }
        }
    }

    private void delayedShutdown(final int exitCode, final long delayMs) {
        LOGGER.info("Started delayed shutdown with delay {} ms.", (Object)delayMs);
        Thread shutdownThread = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(delayMs);
                    LOGGER.warn("Delayed shutdown forced the application to exit with code {}.", (Object)exitCode);
                    Runtime.getRuntime().halt(exitCode);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        };
        shutdownThread.setDaemon(true);
        shutdownThread.setName("delayed-shutdown");
        shutdownThread.start();
    }

    private IArguments parseArguments(String[] args) {
        IArgumentFactory[] accepted = new IArgumentFactory[]{SimanticsArguments.RECOVERY_POLICY_FIX_ERRORS, SimanticsArguments.ONTOLOGY_RECOVERY_POLICY_REINSTALL, SimanticsArguments.DEFAULT_WORKSPACE_LOCATION, SimanticsArguments.WORKSPACE_CHOOSER, SimanticsArguments.WORKSPACE_NO_REMEMBER, SimanticsArguments.PERSPECTIVE, SimanticsArguments.SERVER, SimanticsArguments.NEW_MODEL, SimanticsArguments.EXPERIMENT, SimanticsArguments.DISABLE_INDEX, SimanticsArguments.DATABASE_ID, SimanticsArguments.DO_NOT_SYNCHRONIZE_ONTOLOGIES};
        IArguments result = Arguments.parse((String[])args, (IArgumentFactory[])accepted);
        return result;
    }

    private Object verifyArguments(IArguments args) {
        boolean valid;
        StringBuilder report = new StringBuilder();
        String result = report.toString();
        boolean bl = valid = result.length() == 0;
        if (!valid) {
            String msg = NLS.bind((String)Messages.Application_1, (Object)result);
            MessageDialog.openInformation(null, (String)Messages.Application_2, (String)msg);
        }
        return valid ? null : EXIT_OK;
    }

    protected Display createDisplay() {
        return PlatformUI.createDisplay();
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
    }

    private Object checkInstanceLocation(Shell shell, Map<?, ?> applicationArguments, IArguments args) {
        Location instanceLoc = Platform.getInstanceLocation();
        if (instanceLoc == null) {
            MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.IDEApplication_workspaceMandatoryTitle, (String)IDEWorkbenchMessages.IDEApplication_workspaceMandatoryMessage);
            return EXIT_OK;
        }
        if (instanceLoc.isSet()) {
            block14: {
                if (!this.checkValidWorkspace(shell, instanceLoc.getURL())) {
                    return EXIT_OK;
                }
                if (!instanceLoc.lock()) break block14;
                SimanticsWorkbenchApplication.writeWorkspaceVersion();
                return null;
            }
            try {
                File workspaceDirectory = new File(instanceLoc.getURL().getFile());
                if (workspaceDirectory.exists()) {
                    if (SimanticsWorkbenchApplication.isDevLaunchMode(applicationArguments)) {
                        return EXIT_WORKSPACE_LOCKED;
                    }
                    MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.IDEApplication_workspaceCannotLockTitle, (String)IDEWorkbenchMessages.IDEApplication_workspaceCannotLockMessage);
                } else {
                    MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.IDEApplication_workspaceCannotBeSetTitle, (String)IDEWorkbenchMessages.IDEApplication_workspaceCannotBeSetMessage);
                }
            }
            catch (IOException e) {
                IDEWorkbenchPlugin.log((String)"Could not obtain lock for workspace location", (Throwable)e);
                MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.InternalError, (String)e.getMessage());
            }
            return EXIT_OK;
        }
        ChooseWorkspaceData launchData = null;
        launchData = args.contains(SimanticsArguments.DEFAULT_WORKSPACE_LOCATION) ? new ChooseWorkspaceData((String)args.get(SimanticsArguments.DEFAULT_WORKSPACE_LOCATION)) : new ChooseWorkspaceData(instanceLoc.getDefault());
        boolean force = args.contains(SimanticsArguments.WORKSPACE_CHOOSER);
        boolean suppressAskAgain = args.contains(SimanticsArguments.WORKSPACE_NO_REMEMBER);
        URL workspaceUrl;
        while ((workspaceUrl = this.promptForWorkspace(shell, launchData, force, suppressAskAgain)) != null) {
            force = true;
            try {
                if (instanceLoc.setURL(workspaceUrl, true)) {
                    launchData.writePersistedData();
                    SimanticsWorkbenchApplication.writeWorkspaceVersion();
                    return null;
                }
            }
            catch (IllegalStateException illegalStateException) {
                MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.IDEApplication_workspaceCannotBeSetTitle, (String)IDEWorkbenchMessages.IDEApplication_workspaceCannotBeSetMessage);
                return EXIT_OK;
            }
            MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.IDEApplication_workspaceInUseTitle, (String)IDEWorkbenchMessages.IDEApplication_workspaceInUseMessage);
        }
        return EXIT_OK;
    }

    private static boolean isDevLaunchMode(Map<?, ?> args) {
        if (Boolean.getBoolean("eclipse.pde.launch")) {
            return true;
        }
        return args.containsKey("-pdelaunch");
    }

    private URL promptForWorkspace(Shell shell, ChooseWorkspaceData launchData, boolean force, boolean suppressAskAgain) {
        URL url = null;
        do {
            new ChooseSimanticsWorkspaceDialog(shell, launchData, suppressAskAgain, true).prompt(force);
            String instancePath = launchData.getSelection();
            if (instancePath == null) {
                return null;
            }
            force = true;
            if (instancePath.length() <= 0) {
                MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.IDEApplication_workspaceEmptyTitle, (String)IDEWorkbenchMessages.IDEApplication_workspaceEmptyMessage);
                continue;
            }
            File workspace = new File(instancePath);
            if (!workspace.exists()) {
                workspace.mkdir();
            }
            try {
                String path = workspace.getAbsolutePath().replace(File.separatorChar, '/');
                url = new URL("file", null, path);
            }
            catch (MalformedURLException malformedURLException) {
                MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.IDEApplication_workspaceInvalidTitle, (String)IDEWorkbenchMessages.IDEApplication_workspaceInvalidMessage);
            }
        } while (!this.checkValidWorkspace(shell, url));
        return url;
    }

    private boolean checkValidWorkspace(Shell shell, URL url) {
        String message;
        String title;
        if (url == null) {
            return false;
        }
        String version = SimanticsWorkbenchApplication.readWorkspaceVersion(url);
        if (version == null) {
            return true;
        }
        int ide_version = Integer.parseInt(WORKSPACE_VERSION_VALUE);
        int workspace_version = Integer.parseInt(version);
        if (workspace_version == ide_version) {
            return true;
        }
        if (workspace_version < ide_version) {
            title = IDEWorkbenchMessages.IDEApplication_versionTitle_olderWorkspace;
            message = NLS.bind((String)IDEWorkbenchMessages.IDEApplication_versionMessage_olderWorkspace, (Object)url.getFile());
        } else {
            title = IDEWorkbenchMessages.IDEApplication_versionTitle_newerWorkspace;
            message = NLS.bind((String)IDEWorkbenchMessages.IDEApplication_versionMessage_newerWorkspace, (Object)url.getFile());
        }
        MessageBox mbox = new MessageBox(shell, 65832);
        mbox.setText(title);
        mbox.setMessage(message);
        return mbox.open() == 32;
    }

    private static String readWorkspaceVersion(URL workspace) {
        File versionFile = SimanticsWorkbenchApplication.getVersionFile(workspace, false);
        if (versionFile == null || !versionFile.exists()) {
            return null;
        }
        try {
            Properties props = new Properties();
            try (FileInputStream is = new FileInputStream(versionFile);){
                props.load(is);
            }
            return props.getProperty(WORKSPACE_VERSION_KEY);
        }
        catch (IOException e) {
            IDEWorkbenchPlugin.log((String)"Could not read version file", (IStatus)new Status(4, "org.eclipse.ui.ide", 4, e.getMessage() == null ? "" : e.getMessage(), (Throwable)e));
            return null;
        }
    }

    private static void writeWorkspaceVersion() {
        block16: {
            Location instanceLoc = Platform.getInstanceLocation();
            if (instanceLoc == null || instanceLoc.isReadOnly()) {
                return;
            }
            File versionFile = SimanticsWorkbenchApplication.getVersionFile(instanceLoc.getURL(), true);
            if (versionFile == null) {
                return;
            }
            OutputStream output = null;
            try {
                try {
                    String versionLine = "org.eclipse.core.runtime=1";
                    output = new FileOutputStream(versionFile);
                    output.write(versionLine.getBytes("UTF-8"));
                }
                catch (IOException e) {
                    IDEWorkbenchPlugin.log((String)"Could not write version file", (IStatus)StatusUtil.newStatus((int)4, (String)e.getMessage(), (Throwable)e));
                    try {
                        if (output != null) {
                            output.close();
                        }
                        break block16;
                    }
                    catch (IOException iOException) {}
                    break block16;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static File getVersionFile(URL workspaceUrl, boolean create) {
        File versionFile;
        block6: {
            File metaDir;
            block5: {
                if (workspaceUrl == null) {
                    return null;
                }
                try {
                    metaDir = new File(workspaceUrl.getPath(), METADATA_FOLDER);
                    if (metaDir.exists() || create && metaDir.mkdir()) break block5;
                    return null;
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            versionFile = new File(metaDir, VERSION_FILENAME);
            if (versionFile.exists() || create && versionFile.createNewFile()) break block6;
            return null;
        }
        return versionFile;
    }

    public void stop() {
        final IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        final Display display = workbench.getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (!display.isDisposed()) {
                    workbench.close();
                }
            }
        });
    }

    private static class ChooseSimanticsWorkspaceDialog
    extends ChooseWorkspaceDialog {
        public ChooseSimanticsWorkspaceDialog(Shell parentShell, ChooseWorkspaceData launchData, boolean suppressAskAgain, boolean centerOnMonitor) {
            super(parentShell, launchData, suppressAskAgain, centerOnMonitor);
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(ChooseSimanticsWorkspaceDialog.getWindowTitle());
        }
    }
}

