/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.workbench.internal.preferences;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.Preferences;
import org.simantics.workbench.internal.Activator;

/**
 * @author Tuukka Lehtonen
 */
public class SimanticsPreferenceInitializer extends AbstractPreferenceInitializer {

    @Override
    public void initializeDefaultPreferences() {
        IScopeContext defaults = DefaultScope.INSTANCE;
        Preferences node = defaults.getNode(Activator.PLUGIN_ID);
        node.putBoolean(SimanticsPreferences.SHOW_DATABASE_CONTROLS, false);

        IScopeContext instance = InstanceScope.INSTANCE;
        node = instance.getNode(Activator.PLUGIN_ID);
        boolean show = node.getBoolean(SimanticsPreferences.SHOW_DATABASE_CONTROLS, false);
        if (show)
            System.setProperty(bind(Activator.PLUGIN_ID, SimanticsPreferences.SHOW_DATABASE_CONTROLS), "true");

        // NOTE: the above system property are used in plugin.xml with
        // systemTest in menu contribution visibility checking.
        // This implementation requires a restart every time the preference is changed.
    }

    private static String bind(String namespace, String pref) {
        return namespace + "." + pref;
    }

}
